/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.receive;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.receive.AutoValue_ReceiveCommitsAdvertiseRefsHook_Result;
import com.google.gerrit.server.git.receive.HookUtil;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.server.util.MagicBranch;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.BaseReceivePack;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveCommitsAdvertiseRefsHook
implements AdvertiseRefsHook {
    private static final Logger log = LoggerFactory.getLogger(ReceiveCommitsAdvertiseRefsHook.class);
    private final Provider<InternalChangeQuery> queryProvider;
    private final Project.NameKey projectName;
    private static final ImmutableSet<String> OPEN_CHANGES_FIELDS = ImmutableSet.of(ChangeField.CHANGE.getName(), ChangeField.REVIEWER.getName(), ChangeField.PATCH_SET.getName());

    public ReceiveCommitsAdvertiseRefsHook(Provider<InternalChangeQuery> queryProvider, Project.NameKey projectName) {
        this.queryProvider = queryProvider;
        this.projectName = projectName;
    }

    @Override
    public void advertiseRefs(UploadPack us) {
        throw new UnsupportedOperationException("ReceiveCommitsAdvertiseRefsHook cannot be used for UploadPack");
    }

    @Override
    public void advertiseRefs(BaseReceivePack rp) throws ServiceMayNotContinueException {
        Result r = this.advertiseRefs(HookUtil.ensureAllRefsAdvertised(rp));
        rp.setAdvertisedRefs(r.allRefs(), r.additionalHaves());
    }

    @VisibleForTesting
    public Result advertiseRefs(Map<String, Ref> oldRefs) {
        HashMap<String, Ref> r = Maps.newHashMapWithExpectedSize(oldRefs.size());
        HashSet<ObjectId> allPatchSets = Sets.newHashSetWithExpectedSize(oldRefs.size());
        for (Map.Entry<String, Ref> e : oldRefs.entrySet()) {
            String name = e.getKey();
            if (!ReceiveCommitsAdvertiseRefsHook.skip(name)) {
                r.put(name, e.getValue());
            }
            if (!name.startsWith("refs/changes/")) continue;
            allPatchSets.add(e.getValue().getObjectId());
        }
        return new AutoValue_ReceiveCommitsAdvertiseRefsHook_Result(r, this.advertiseOpenChanges(allPatchSets));
    }

    private Set<ObjectId> advertiseOpenChanges(Set<ObjectId> allPatchSets) {
        int limit = 32;
        try {
            HashSet<ObjectId> r = Sets.newHashSetWithExpectedSize(limit);
            for (ChangeData cd : ((InternalChangeQuery)this.queryProvider.get().setRequestedFields(OPEN_CHANGES_FIELDS)).enforceVisibility(true).setLimit(limit).byProjectOpen(this.projectName)) {
                ObjectId id;
                PatchSet ps = cd.currentPatchSet();
                if (ps == null || !allPatchSets.contains(id = ObjectId.fromString(ps.getRevision().get()))) continue;
                r.add(id);
            }
            return r;
        }
        catch (OrmException err) {
            log.error("Cannot list open changes of " + this.projectName, err);
            return Collections.emptySet();
        }
    }

    private static boolean skip(String name) {
        return name.startsWith("refs/changes/") || name.startsWith("refs/cache-automerge/") || MagicBranch.isMagicBranch(name);
    }

    @VisibleForTesting
    @AutoValue
    public static abstract class Result {
        public abstract Map<String, Ref> allRefs();

        public abstract Set<ObjectId> additionalHaves();
    }
}

