/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.extensions.restapi.MergeConflictException;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.MergeIdenticalTreeException;
import com.google.gerrit.server.git.MergeTip;
import com.google.gerrit.server.git.strategy.CommitMergeStatus;
import com.google.gerrit.server.git.strategy.FastForwardOp;
import com.google.gerrit.server.git.strategy.SubmitDryRun;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.git.strategy.SubmitStrategyOp;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.RepoContext;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;

public class CherryPick
extends SubmitStrategy {
    CherryPick(SubmitStrategy.Arguments args) {
        super(args);
    }

    @Override
    public List<SubmitStrategyOp> buildOps(Collection<CodeReviewCommit> toMerge) throws IntegrationException {
        List<CodeReviewCommit> sorted = CodeReviewCommit.ORDER.sortedCopy(toMerge);
        ArrayList<SubmitStrategyOp> ops = new ArrayList<SubmitStrategyOp>(sorted.size());
        boolean first = true;
        while (!sorted.isEmpty()) {
            CodeReviewCommit n = sorted.remove(0);
            if (first && this.args.mergeTip.getInitialTip() == null) {
                ops.add(new FastForwardOp(this.args, n));
            } else if (n.getParentCount() == 0) {
                ops.add(new CherryPickRootOp(n));
            } else if (n.getParentCount() == 1) {
                ops.add(new CherryPickOneOp(n));
            } else {
                ops.add(new CherryPickMultipleParentsOp(n));
            }
            first = false;
        }
        return ops;
    }

    static boolean dryRun(SubmitDryRun.Arguments args, CodeReviewCommit mergeTip, CodeReviewCommit toMerge) throws IntegrationException {
        return args.mergeUtil.canCherryPick(args.mergeSorter, args.repo, mergeTip, args.rw, toMerge);
    }

    private class CherryPickMultipleParentsOp
    extends SubmitStrategyOp {
        private CherryPickMultipleParentsOp(CodeReviewCommit toMerge) {
            super(CherryPick.this.args, toMerge);
        }

        @Override
        public void updateRepoImpl(RepoContext ctx) throws IntegrationException, IOException {
            if (this.args.mergeUtil.hasMissingDependencies(this.args.mergeSorter, this.toMerge)) {
                return;
            }
            MergeTip mergeTip = this.args.mergeTip;
            if (this.args.rw.isMergedInto(mergeTip.getCurrentTip(), this.toMerge) && !this.args.submoduleOp.hasSubscription(this.args.destBranch)) {
                mergeTip.moveTipTo(this.toMerge, this.toMerge);
            } else {
                PersonIdent myIdent = new PersonIdent(this.args.serverIdent, ctx.getWhen());
                CodeReviewCommit result = this.args.mergeUtil.mergeOneCommit(myIdent, myIdent, this.args.rw, ctx.getInserter(), ctx.getRepoView().getConfig(), this.args.destBranch, mergeTip.getCurrentTip(), this.toMerge);
                result = this.amendGitlink(result);
                mergeTip.moveTipTo(result, this.toMerge);
                this.args.mergeUtil.markCleanMerges(this.args.rw, this.args.canMergeFlag, mergeTip.getCurrentTip(), this.args.alreadyAccepted);
            }
        }
    }

    private class CherryPickOneOp
    extends SubmitStrategyOp {
        private PatchSet.Id psId;
        private CodeReviewCommit newCommit;
        private PatchSetInfo patchSetInfo;

        private CherryPickOneOp(CodeReviewCommit toMerge) {
            super(CherryPick.this.args, toMerge);
        }

        @Override
        protected void updateRepoImpl(RepoContext ctx) throws IntegrationException, IOException, OrmException {
            this.args.rw.parseBody(this.toMerge);
            this.psId = ChangeUtil.nextPatchSetIdFromChangeRefsMap(ctx.getRepoView().getRefs(this.getId().toRefPrefix()), this.toMerge.change().currentPatchSetId());
            CodeReviewCommit mergeTip = this.args.mergeTip.getCurrentTip();
            this.args.rw.parseBody(mergeTip);
            String cherryPickCmtMsg = this.args.mergeUtil.createCommitMessageOnSubmit(this.toMerge, mergeTip);
            PersonIdent committer = this.args.caller.newCommitterIdent(ctx.getWhen(), this.args.serverIdent.getTimeZone());
            try {
                this.newCommit = this.args.mergeUtil.createCherryPickFromCommit(ctx.getInserter(), ctx.getRepoView().getConfig(), this.args.mergeTip.getCurrentTip(), this.toMerge, committer, cherryPickCmtMsg, this.args.rw, 0, false);
            }
            catch (MergeConflictException mce) {
                this.toMerge.setStatusCode(CommitMergeStatus.PATH_CONFLICT);
                return;
            }
            catch (MergeIdenticalTreeException mie) {
                this.toMerge.setStatusCode(CommitMergeStatus.SKIPPED_IDENTICAL_TREE);
                return;
            }
            this.newCommit = this.amendGitlink(this.newCommit);
            this.newCommit.copyFrom(this.toMerge);
            this.newCommit.setPatchsetId(this.psId);
            this.newCommit.setStatusCode(CommitMergeStatus.CLEAN_PICK);
            this.args.mergeTip.moveTipTo(this.newCommit, this.newCommit);
            this.args.commitStatus.put(this.newCommit);
            ctx.addRefUpdate(ObjectId.zeroId(), this.newCommit, this.psId.toRefName());
            this.patchSetInfo = this.args.patchSetInfoFactory.get(ctx.getRevWalk(), this.newCommit, this.psId);
        }

        @Override
        public PatchSet updateChangeImpl(ChangeContext ctx) throws OrmException, NoSuchChangeException, IOException {
            if (this.newCommit == null && this.toMerge.getStatusCode() == CommitMergeStatus.SKIPPED_IDENTICAL_TREE) {
                return null;
            }
            Preconditions.checkNotNull(this.newCommit, "no new commit produced by CherryPick of %s, expected to fail fast", (Object)this.toMerge.change().getId());
            PatchSet prevPs = this.args.psUtil.current(ctx.getDb(), ctx.getNotes());
            PatchSet newPs = this.args.psUtil.insert(ctx.getDb(), ctx.getRevWalk(), ctx.getUpdate(this.psId), this.psId, this.newCommit, prevPs != null ? prevPs.getGroups() : ImmutableList.of(), null, null);
            ctx.getChange().setCurrentPatchSet(this.patchSetInfo);
            this.newCommit.setNotes(ctx.getNotes());
            return newPs;
        }
    }

    private class CherryPickRootOp
    extends SubmitStrategyOp {
        private CherryPickRootOp(CodeReviewCommit toMerge) {
            super(CherryPick.this.args, toMerge);
        }

        @Override
        public void updateRepoImpl(RepoContext ctx) {
            this.toMerge.setStatusCode(CommitMergeStatus.CANNOT_CHERRY_PICK_ROOT);
        }
    }
}

