/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.strategy.FastForwardOp;
import com.google.gerrit.server.git.strategy.MergeOneOp;
import com.google.gerrit.server.git.strategy.SubmitDryRun;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.git.strategy.SubmitStrategyOp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MergeIfNecessary
extends SubmitStrategy {
    MergeIfNecessary(SubmitStrategy.Arguments args) {
        super(args);
    }

    @Override
    public List<SubmitStrategyOp> buildOps(Collection<CodeReviewCommit> toMerge) throws IntegrationException {
        CodeReviewCommit firstFastForward;
        List<CodeReviewCommit> sorted = this.args.mergeUtil.reduceToMinimalMerge(this.args.mergeSorter, toMerge);
        ArrayList<SubmitStrategyOp> ops = new ArrayList<SubmitStrategyOp>(sorted.size());
        if (!(this.args.mergeTip.getInitialTip() != null && this.args.submoduleOp.hasSubscription(this.args.destBranch) || (firstFastForward = this.args.mergeUtil.getFirstFastForward(this.args.mergeTip.getInitialTip(), this.args.rw, sorted)) == null || firstFastForward.equals(this.args.mergeTip.getInitialTip()))) {
            ops.add(new FastForwardOp(this.args, firstFastForward));
        }
        while (!sorted.isEmpty()) {
            CodeReviewCommit n = sorted.remove(0);
            ops.add(new MergeOneOp(this.args, n));
        }
        return ops;
    }

    static boolean dryRun(SubmitDryRun.Arguments args, CodeReviewCommit mergeTip, CodeReviewCommit toMerge) throws IntegrationException {
        return args.mergeUtil.canFastForward(args.mergeSorter, mergeTip, args.rw, toMerge) || args.mergeUtil.canMerge(args.mergeSorter, args.repo, mergeTip, toMerge);
    }
}

