/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ReviewerSet;
import com.google.gerrit.server.notedb.ChangeBundle;
import com.google.gerrit.server.notedb.ChangeBundleReader;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;

@Singleton
public class GwtormChangeBundleReader
implements ChangeBundleReader {
    @Inject
    GwtormChangeBundleReader() {
    }

    @Override
    @Nullable
    public ChangeBundle fromReviewDb(ReviewDb db, Change.Id id) throws OrmException {
        Change reviewDbChange = db.changes().get(id);
        if (reviewDbChange == null) {
            return null;
        }
        List<PatchSetApproval> approvals = db.patchSetApprovals().byChange(id).toList();
        return new ChangeBundle(reviewDbChange, db.changeMessages().byChange(id), db.patchSets().byChange(id), approvals, db.patchComments().byChange(id), ReviewerSet.fromApprovals(approvals), ChangeBundle.Source.REVIEW_DB);
    }
}

