/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.notedb.NotesMigration;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jgit.lib.Config;

public enum NotesMigrationState {
    REVIEW_DB(false, false, false, NoteDbChangeState.PrimaryStorage.REVIEW_DB, false),
    WRITE(false, true, false, NoteDbChangeState.PrimaryStorage.REVIEW_DB, false),
    READ_WRITE_NO_SEQUENCE(true, true, false, NoteDbChangeState.PrimaryStorage.REVIEW_DB, false),
    READ_WRITE_WITH_SEQUENCE_REVIEW_DB_PRIMARY(true, true, true, NoteDbChangeState.PrimaryStorage.REVIEW_DB, false),
    READ_WRITE_WITH_SEQUENCE_NOTE_DB_PRIMARY(true, true, true, NoteDbChangeState.PrimaryStorage.NOTE_DB, false),
    NOTE_DB(true, true, true, NoteDbChangeState.PrimaryStorage.NOTE_DB, true);

    public static final NotesMigrationState FINAL;
    private final NotesMigration.Snapshot snapshot;

    public static Optional<NotesMigrationState> forConfig(Config cfg) {
        return NotesMigrationState.forSnapshot(NotesMigration.Snapshot.create(cfg));
    }

    public static Optional<NotesMigrationState> forNotesMigration(NotesMigration migration) {
        return NotesMigrationState.forSnapshot(migration.snapshot());
    }

    private static Optional<NotesMigrationState> forSnapshot(NotesMigration.Snapshot s) {
        return Stream.of(NotesMigrationState.values()).filter(v -> v.snapshot.equals(s)).findFirst();
    }

    private NotesMigrationState(boolean readChanges, boolean rawWriteChangesSetting, boolean readChangeSequence, NoteDbChangeState.PrimaryStorage changePrimaryStorage, boolean disableChangeReviewDb) {
        this.snapshot = NotesMigration.Snapshot.builder().setReadChanges(readChanges).setWriteChanges(rawWriteChangesSetting).setReadChangeSequence(readChangeSequence).setChangePrimaryStorage(changePrimaryStorage).setDisableChangeReviewDb(disableChangeReviewDb).build();
    }

    public void setConfigValues(Config cfg) {
        this.snapshot.setConfigValues(cfg);
    }

    public String toText() {
        Config cfg = new Config();
        this.setConfigValues(cfg);
        return cfg.toText();
    }

    NotesMigration.Snapshot snapshot() {
        return this.snapshot;
    }

    static {
        FINAL = NOTE_DB;
    }
}

