/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.permissions;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.server.permissions.ChangePermissionOrLabel;
import com.google.gerrit.server.util.LabelVote;
import java.util.Optional;

public class LabelPermission
implements ChangePermissionOrLabel {
    private final ForUser forUser;
    private final String name;

    public LabelPermission(LabelType type) {
        this(ForUser.SELF, type);
    }

    public LabelPermission(ForUser forUser, LabelType type) {
        this(forUser, type.getName());
    }

    public LabelPermission(String name) {
        this(ForUser.SELF, name);
    }

    public LabelPermission(ForUser forUser, String name) {
        this.forUser = Preconditions.checkNotNull(forUser, "ForUser");
        this.name = LabelType.checkName(name);
    }

    public ForUser forUser() {
        return this.forUser;
    }

    public String label() {
        return this.name;
    }

    @Override
    public Optional<String> permissionName() {
        switch (this.forUser) {
            case SELF: {
                return Optional.of(Permission.forLabel(this.name));
            }
            case ON_BEHALF_OF: {
                return Optional.of(Permission.forLabelAs(this.name));
            }
        }
        return Optional.empty();
    }

    @Override
    public String describeForException() {
        if (this.forUser == ForUser.ON_BEHALF_OF) {
            return "labelAs " + this.name;
        }
        return "label " + this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof LabelPermission) {
            LabelPermission b = (LabelPermission)other;
            return this.forUser == b.forUser && this.name.equals(b.name);
        }
        return false;
    }

    public String toString() {
        if (this.forUser == ForUser.ON_BEHALF_OF) {
            return "LabelAs[" + this.name + ']';
        }
        return "Label[" + this.name + ']';
    }

    public static class WithValue
    implements ChangePermissionOrLabel {
        private final ForUser forUser;
        private final LabelVote label;

        public WithValue(LabelType type, LabelValue value) {
            this(ForUser.SELF, type, value);
        }

        public WithValue(LabelType type, short value) {
            this(ForUser.SELF, type.getName(), value);
        }

        public WithValue(ForUser forUser, LabelType type, LabelValue value) {
            this(forUser, type.getName(), value.getValue());
        }

        public WithValue(ForUser forUser, LabelType type, short value) {
            this(forUser, type.getName(), value);
        }

        public WithValue(String name, short value) {
            this(ForUser.SELF, name, value);
        }

        public WithValue(ForUser forUser, String name, short value) {
            this(forUser, LabelVote.create(name, value));
        }

        public WithValue(LabelVote label) {
            this(ForUser.SELF, label);
        }

        public WithValue(ForUser forUser, LabelVote label) {
            this.forUser = Preconditions.checkNotNull(forUser, "ForUser");
            this.label = Preconditions.checkNotNull(label, "LabelVote");
        }

        public ForUser forUser() {
            return this.forUser;
        }

        public String label() {
            return this.label.label();
        }

        public short value() {
            return this.label.value();
        }

        @Override
        public Optional<String> permissionName() {
            switch (this.forUser) {
                case SELF: {
                    return Optional.of(Permission.forLabel(this.label()));
                }
                case ON_BEHALF_OF: {
                    return Optional.of(Permission.forLabelAs(this.label()));
                }
            }
            return Optional.empty();
        }

        @Override
        public String describeForException() {
            if (this.forUser == ForUser.ON_BEHALF_OF) {
                return "labelAs " + this.label.formatWithEquals();
            }
            return "label " + this.label.formatWithEquals();
        }

        public int hashCode() {
            return this.label.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof WithValue) {
                WithValue b = (WithValue)other;
                return this.forUser == b.forUser && this.label.equals(b.label);
            }
            return false;
        }

        public String toString() {
            if (this.forUser == ForUser.ON_BEHALF_OF) {
                return "LabelAs[" + this.label.format() + ']';
            }
            return "Label[" + this.label.format() + ']';
        }
    }

    public static enum ForUser {
        SELF,
        ON_BEHALF_OF;

    }
}

