/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.BranchResource;
import com.google.gerrit.server.project.CreateBranch;
import com.google.gerrit.server.project.ListBranches;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class BranchesCollection
implements ChildCollection<ProjectResource, BranchResource>,
AcceptsCreate<ProjectResource> {
    private final DynamicMap<RestView<BranchResource>> views;
    private final Provider<ListBranches> list;
    private final PermissionBackend permissionBackend;
    private final Provider<CurrentUser> user;
    private final GitRepositoryManager repoManager;
    private final CreateBranch.Factory createBranchFactory;

    @Inject
    BranchesCollection(DynamicMap<RestView<BranchResource>> views, Provider<ListBranches> list, PermissionBackend permissionBackend, Provider<CurrentUser> user, GitRepositoryManager repoManager, CreateBranch.Factory createBranchFactory) {
        this.views = views;
        this.list = list;
        this.permissionBackend = permissionBackend;
        this.user = user;
        this.repoManager = repoManager;
        this.createBranchFactory = createBranchFactory;
    }

    @Override
    public RestView<ProjectResource> list() {
        return this.list.get();
    }

    @Override
    public BranchResource parse(ProjectResource parent, IdString id) throws ResourceNotFoundException, IOException, PermissionBackendException {
        Project.NameKey project = parent.getNameKey();
        Repository repo = this.repoManager.openRepository(project);
        try {
            Ref ref = repo.exactRef(RefNames.fullName(id.get()));
            if (ref == null) {
                throw new ResourceNotFoundException(id);
            }
            this.permissionBackend.user(this.user).project(project).ref(ref.isSymbolic() ? ref.getTarget().getName() : ref.getName()).check(RefPermission.READ);
            BranchResource branchResource = new BranchResource(parent.getControl(), ref);
            if (repo != null) {
                repo.close();
            }
            return branchResource;
        }
        catch (Throwable throwable) {
            try {
                if (repo != null) {
                    try {
                        repo.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AuthException notAllowed) {
                throw new ResourceNotFoundException(id);
            }
            catch (RepositoryNotFoundException noRepo) {
                throw new ResourceNotFoundException();
            }
        }
    }

    @Override
    public DynamicMap<RestView<BranchResource>> views() {
        return this.views;
    }

    public CreateBranch create(ProjectResource parent, IdString name) {
        return this.createBranchFactory.create(name.get());
    }
}

