/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.LabelFunction;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.ChangePermissionOrLabel;
import com.google.gerrit.server.permissions.LabelPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

class ChangeControl {
    private final ChangeData.Factory changeDataFactory;
    private final ApprovalsUtil approvalsUtil;
    private final RefControl refControl;
    private final ChangeNotes notes;
    private final PatchSetUtil patchSetUtil;

    ChangeControl(ChangeData.Factory changeDataFactory, ApprovalsUtil approvalsUtil, RefControl refControl, ChangeNotes notes, PatchSetUtil patchSetUtil) {
        this.changeDataFactory = changeDataFactory;
        this.approvalsUtil = approvalsUtil;
        this.refControl = refControl;
        this.notes = notes;
        this.patchSetUtil = patchSetUtil;
    }

    ChangeControl forUser(CurrentUser who) {
        if (this.getUser().equals(who)) {
            return this;
        }
        return new ChangeControl(this.changeDataFactory, this.approvalsUtil, this.getRefControl().forUser(who), this.notes, this.patchSetUtil);
    }

    private RefControl getRefControl() {
        return this.refControl;
    }

    private CurrentUser getUser() {
        return this.getRefControl().getUser();
    }

    private ProjectControl getProjectControl() {
        return this.getRefControl().getProjectControl();
    }

    private Change getChange() {
        return this.notes.getChange();
    }

    private ChangeNotes getNotes() {
        return this.notes;
    }

    private boolean isVisible(ReviewDb db, @Nullable ChangeData cd) throws OrmException {
        if (this.getChange().isPrivate() && !this.isPrivateVisible(db, cd)) {
            return false;
        }
        return this.isRefVisible();
    }

    private boolean isRefVisible() {
        return this.getRefControl().isVisible();
    }

    private boolean canAbandon(ReviewDb db) throws OrmException {
        return (this.isOwner() || this.getRefControl().isOwner() || this.getProjectControl().isOwner() || this.getRefControl().canAbandon() || this.getProjectControl().isAdmin()) && !this.isPatchSetLocked(db);
    }

    private boolean canDelete(Change.Status status) {
        switch (status) {
            case NEW: 
            case ABANDONED: {
                return this.getRefControl().canDeleteChanges(this.isOwner()) || this.getProjectControl().isAdmin();
            }
        }
        return false;
    }

    private boolean canRebase(ReviewDb db) throws OrmException {
        return (this.isOwner() || this.getRefControl().canSubmit(this.isOwner()) || this.getRefControl().canRebase()) && this.refControl.asForRef().testOrFalse(RefPermission.CREATE_CHANGE) && !this.isPatchSetLocked(db);
    }

    private boolean canRestore(ReviewDb db) throws OrmException {
        return this.canAbandon(db) && this.refControl.asForRef().testOrFalse(RefPermission.CREATE_CHANGE);
    }

    private PermissionRange getRange(String permission) {
        return this.getRefControl().getRange(permission, this.isOwner());
    }

    private boolean canAddPatchSet(ReviewDb db) throws OrmException {
        if (!this.refControl.asForRef().testOrFalse(RefPermission.CREATE_CHANGE) || this.isPatchSetLocked(db)) {
            return false;
        }
        if (this.isOwner()) {
            return true;
        }
        return this.getRefControl().canAddPatchSet();
    }

    private boolean isPatchSetLocked(ReviewDb db) throws OrmException {
        if (this.getChange().getStatus() == Change.Status.MERGED) {
            return false;
        }
        for (PatchSetApproval ap : this.approvalsUtil.byPatchSet(db, this.getNotes(), this.getUser(), this.getChange().currentPatchSetId(), null, null)) {
            LabelType type = this.getProjectControl().getProjectState().getLabelTypes(this.getNotes(), this.getUser()).byLabel(ap.getLabel());
            if (type == null || ap.getValue() != 1 || type.getFunction() != LabelFunction.PATCH_SET_LOCK) continue;
            return true;
        }
        return false;
    }

    private boolean isOwner() {
        if (this.getUser().isIdentifiedUser()) {
            Account.Id id = this.getUser().asIdentifiedUser().getAccountId();
            return id.equals(this.getChange().getOwner());
        }
        return false;
    }

    private boolean isAssignee() {
        Account.Id currentAssignee = this.notes.getChange().getAssignee();
        if (currentAssignee != null && this.getUser().isIdentifiedUser()) {
            Account.Id id = this.getUser().getAccountId();
            return id.equals(currentAssignee);
        }
        return false;
    }

    private boolean isReviewer(ReviewDb db, @Nullable ChangeData cd) throws OrmException {
        if (this.getUser().isIdentifiedUser()) {
            ImmutableSet<Account.Id> results = this.changeData(db, cd).reviewers().all();
            return results.contains(this.getUser().getAccountId());
        }
        return false;
    }

    private boolean canEditTopicName() {
        if (this.getChange().getStatus().isOpen()) {
            return this.isOwner() || this.getRefControl().isOwner() || this.getProjectControl().isOwner() || this.getRefControl().canEditTopicName() || this.getProjectControl().isAdmin();
        }
        return this.getRefControl().canForceEditTopicName();
    }

    private boolean canEditDescription() {
        if (this.getChange().getStatus().isOpen()) {
            return this.isOwner() || this.getRefControl().isOwner() || this.getProjectControl().isOwner() || this.getProjectControl().isAdmin();
        }
        return false;
    }

    private boolean canEditAssignee() {
        return this.isOwner() || this.getProjectControl().isOwner() || this.getRefControl().canEditAssignee() || this.isAssignee();
    }

    private boolean canEditHashtags() {
        return this.isOwner() || this.getRefControl().isOwner() || this.getProjectControl().isOwner() || this.getRefControl().canEditHashtags() || this.getProjectControl().isAdmin();
    }

    private ChangeData changeData(ReviewDb db, @Nullable ChangeData cd) {
        return cd != null ? cd : this.changeDataFactory.create(db, this.getNotes());
    }

    private boolean isPrivateVisible(ReviewDb db, ChangeData cd) throws OrmException {
        return this.isOwner() || this.isReviewer(db, cd) || this.getRefControl().canViewPrivateChanges() || this.getUser().isInternalUser();
    }

    PermissionBackend.ForChange asForChange(@Nullable ChangeData cd, @Nullable Provider<ReviewDb> db) {
        return new ForChangeImpl(cd, db);
    }

    static <T extends ChangePermissionOrLabel> Set<T> newSet(Collection<T> permSet) {
        if (permSet instanceof EnumSet) {
            Object s = ((EnumSet)permSet).clone();
            s.clear();
            return s;
        }
        return Sets.newHashSetWithExpectedSize(permSet.size());
    }

    private class ForChangeImpl
    extends PermissionBackend.ForChange {
        private ChangeData cd;
        private Map<String, PermissionRange> labels;

        ForChangeImpl(@Nullable ChangeData cd, Provider<ReviewDb> db) {
            this.cd = cd;
            this.db = db;
        }

        private ReviewDb db() {
            if (this.db != null) {
                return (ReviewDb)this.db.get();
            }
            if (this.cd != null) {
                return this.cd.db();
            }
            return null;
        }

        private ChangeData changeData() {
            if (this.cd == null) {
                ReviewDb reviewDb = this.db();
                Preconditions.checkState(reviewDb != null, "need ReviewDb");
                this.cd = ChangeControl.this.changeDataFactory.create(reviewDb, ChangeControl.this.getNotes());
            }
            return this.cd;
        }

        @Override
        public CurrentUser user() {
            return ChangeControl.this.getUser();
        }

        @Override
        public PermissionBackend.ForChange user(CurrentUser user) {
            return this.user().equals(user) ? this : ChangeControl.this.forUser(user).asForChange(this.cd, this.db);
        }

        @Override
        public void check(ChangePermissionOrLabel perm) throws AuthException, PermissionBackendException {
            if (!this.can(perm)) {
                throw new AuthException(perm.describeForException() + " not permitted");
            }
        }

        @Override
        public <T extends ChangePermissionOrLabel> Set<T> test(Collection<T> permSet) throws PermissionBackendException {
            Set<T> ok = ChangeControl.newSet(permSet);
            for (ChangePermissionOrLabel perm : permSet) {
                if (!this.can(perm)) continue;
                ok.add(perm);
            }
            return ok;
        }

        private boolean can(ChangePermissionOrLabel perm) throws PermissionBackendException {
            if (perm instanceof ChangePermission) {
                return this.can((ChangePermission)perm);
            }
            if (perm instanceof LabelPermission) {
                return this.can((LabelPermission)perm);
            }
            if (perm instanceof LabelPermission.WithValue) {
                return this.can((LabelPermission.WithValue)perm);
            }
            throw new PermissionBackendException(perm + " unsupported");
        }

        private boolean can(ChangePermission perm) throws PermissionBackendException {
            try {
                switch (perm) {
                    case READ: {
                        return ChangeControl.this.isVisible(this.db(), this.changeData());
                    }
                    case ABANDON: {
                        return ChangeControl.this.canAbandon(this.db());
                    }
                    case DELETE: {
                        return ChangeControl.this.canDelete(ChangeControl.this.getChange().getStatus());
                    }
                    case ADD_PATCH_SET: {
                        return ChangeControl.this.canAddPatchSet(this.db());
                    }
                    case EDIT_ASSIGNEE: {
                        return ChangeControl.this.canEditAssignee();
                    }
                    case EDIT_DESCRIPTION: {
                        return ChangeControl.this.canEditDescription();
                    }
                    case EDIT_HASHTAGS: {
                        return ChangeControl.this.canEditHashtags();
                    }
                    case EDIT_TOPIC_NAME: {
                        return ChangeControl.this.canEditTopicName();
                    }
                    case REBASE: {
                        return ChangeControl.this.canRebase(this.db());
                    }
                    case RESTORE: {
                        return ChangeControl.this.canRestore(this.db());
                    }
                    case SUBMIT: {
                        return ChangeControl.this.getRefControl().canSubmit(ChangeControl.this.isOwner());
                    }
                    case REMOVE_REVIEWER: 
                    case SUBMIT_AS: {
                        return ChangeControl.this.getRefControl().canPerform(perm.permissionName().get());
                    }
                }
            }
            catch (OrmException e) {
                throw new PermissionBackendException("unavailable", e);
            }
            throw new PermissionBackendException(perm + " unsupported");
        }

        private boolean can(LabelPermission perm) {
            return !this.label(perm.permissionName().get()).isEmpty();
        }

        private boolean can(LabelPermission.WithValue perm) {
            PermissionRange r = this.label(perm.permissionName().get());
            if (perm.forUser() == LabelPermission.ForUser.ON_BEHALF_OF && r.isEmpty()) {
                return false;
            }
            return r.contains(perm.value());
        }

        private PermissionRange label(String permission) {
            PermissionRange r;
            if (this.labels == null) {
                this.labels = Maps.newHashMapWithExpectedSize(4);
            }
            if ((r = this.labels.get(permission)) == null) {
                r = ChangeControl.this.getRange(permission);
                this.labels.put(permission, r);
            }
            return r;
        }
    }

    @Singleton
    static class Factory {
        private final ChangeData.Factory changeDataFactory;
        private final ChangeNotes.Factory notesFactory;
        private final ApprovalsUtil approvalsUtil;
        private final PatchSetUtil patchSetUtil;

        @Inject
        Factory(ChangeData.Factory changeDataFactory, ChangeNotes.Factory notesFactory, ApprovalsUtil approvalsUtil, PatchSetUtil patchSetUtil) {
            this.changeDataFactory = changeDataFactory;
            this.notesFactory = notesFactory;
            this.approvalsUtil = approvalsUtil;
            this.patchSetUtil = patchSetUtil;
        }

        ChangeControl create(RefControl refControl, ReviewDb db, Project.NameKey project, Change.Id changeId) throws OrmException {
            return this.create(refControl, this.notesFactory.create(db, project, changeId));
        }

        ChangeControl create(RefControl refControl, ChangeNotes notes) {
            return new ChangeControl(this.changeDataFactory, this.approvalsUtil, refControl, notes, this.patchSetUtil);
        }
    }
}

