/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.auto.value.AutoValue;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.project.AutoValue_SectionSortCache_EntryKey;
import com.google.gerrit.server.util.MostSpecificComparator;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SectionSortCache {
    private static final Logger log = LoggerFactory.getLogger(SectionSortCache.class);
    private static final String CACHE_NAME = "permission_sort";
    private final Cache<EntryKey, EntryVal> cache;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(SectionSortCache.CACHE_NAME, EntryKey.class, EntryVal.class);
                this.bind(SectionSortCache.class);
            }
        };
    }

    @Inject
    SectionSortCache(@Named(value="permission_sort") Cache<EntryKey, EntryVal> cache) {
        this.cache = cache;
    }

    void sort(String ref, List<AccessSection> sections) {
        int cnt = sections.size();
        if (cnt <= 1) {
            return;
        }
        EntryKey key = EntryKey.create(ref, sections);
        EntryVal val = this.cache.getIfPresent(key);
        if (val != null) {
            int[] srcIdx = val.order;
            if (srcIdx != null) {
                AccessSection[] srcList = SectionSortCache.copy(sections);
                for (int i = 0; i < cnt; ++i) {
                    sections.set(i, srcList[srcIdx[i]]);
                }
            }
        } else {
            int[] srcIdx;
            boolean poison = false;
            IdentityHashMap<AccessSection, Integer> srcMap = new IdentityHashMap<AccessSection, Integer>();
            for (int i = 0; i < cnt; ++i) {
                poison |= srcMap.put(sections.get(i), i) != null;
            }
            Collections.sort(sections, new MostSpecificComparator(ref));
            if (SectionSortCache.isIdentityTransform(sections, srcMap)) {
                srcIdx = null;
            } else {
                srcIdx = new int[cnt];
                for (int i = 0; i < cnt; ++i) {
                    srcIdx[i] = srcMap.get(sections.get(i));
                }
            }
            if (poison) {
                log.error("Received duplicate AccessSection instances, not caching sort");
            } else {
                this.cache.put(key, new EntryVal(srcIdx));
            }
        }
    }

    private static AccessSection[] copy(List<AccessSection> sections) {
        return sections.toArray(new AccessSection[sections.size()]);
    }

    private static boolean isIdentityTransform(List<AccessSection> sections, IdentityHashMap<AccessSection, Integer> srcMap) {
        for (int i = 0; i < sections.size(); ++i) {
            if (i == srcMap.get(sections.get(i))) continue;
            return false;
        }
        return true;
    }

    static final class EntryVal {
        final int[] order;

        EntryVal(int[] order) {
            this.order = order;
        }
    }

    @AutoValue
    static abstract class EntryKey {
        EntryKey() {
        }

        public abstract String ref();

        public abstract List<String> patterns();

        public abstract int cachedHashCode();

        static EntryKey create(String refName, List<AccessSection> sections) {
            int hc = refName.hashCode();
            ArrayList<String> patterns = new ArrayList<String>(sections.size());
            for (AccessSection s : sections) {
                String n = s.getName();
                patterns.add(n);
                hc = hc * 31 + n.hashCode();
            }
            return new AutoValue_SectionSortCache_EntryKey(refName, ImmutableList.copyOf(patterns), hc);
        }

        public int hashCode() {
            return this.cachedHashCode();
        }
    }
}

