/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.common.Version;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.schema.AclUtil;
import com.google.gerrit.server.schema.AllProjectsCreator;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

public class AllUsersCreator {
    private final GitRepositoryManager mgr;
    private final AllUsersName allUsersName;
    private final PersonIdent serverUser;
    private final GroupReference registered;
    private GroupReference admin;

    @Inject
    AllUsersCreator(GitRepositoryManager mgr, AllUsersName allUsersName, SystemGroupBackend systemGroupBackend, @GerritPersonIdent PersonIdent serverUser) {
        this.mgr = mgr;
        this.allUsersName = allUsersName;
        this.serverUser = serverUser;
        this.registered = systemGroupBackend.getGroup(SystemGroupBackend.REGISTERED_USERS);
    }

    public AllUsersCreator setAdministrators(GroupReference admin) {
        this.admin = admin;
        return this;
    }

    public void create() throws IOException, ConfigInvalidException {
        try (Repository git = this.mgr.openRepository(this.allUsersName);){
            this.initAllUsers(git);
        }
        catch (RepositoryNotFoundException notFound) {
            try (Repository git2 = this.mgr.createRepository(this.allUsersName);){
                this.initAllUsers(git2);
            }
            catch (RepositoryNotFoundException err) {
                String name = this.allUsersName.get();
                throw new IOException("Cannot create repository " + name, err);
            }
        }
    }

    private void initAllUsers(Repository git) throws IOException, ConfigInvalidException {
        try (MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allUsersName, git);){
            md.getCommitBuilder().setAuthor(this.serverUser);
            md.getCommitBuilder().setCommitter(this.serverUser);
            md.setMessage("Initialized Gerrit Code Review " + Version.getVersion());
            ProjectConfig config = ProjectConfig.read(md);
            Project project = config.getProject();
            project.setDescription("Individual user settings and preferences.");
            AccessSection users = config.getAccessSection("refs/users/${shardeduserid}", true);
            LabelType cr = AllProjectsCreator.initCodeReviewLabel(config);
            AclUtil.grant(config, users, "read", false, true, this.registered);
            AclUtil.grant(config, users, "push", false, true, this.registered);
            AclUtil.grant(config, users, "submit", false, true, this.registered);
            AclUtil.grant(config, users, cr, -2, 2, this.registered);
            AccessSection defaults = config.getAccessSection("refs/users/default", true);
            defaults.getPermission("read", true).setExclusiveGroup(true);
            AclUtil.grant(config, defaults, "read", this.admin);
            defaults.getPermission("push", true).setExclusiveGroup(true);
            AclUtil.grant(config, defaults, "push", this.admin);
            defaults.getPermission("create", true).setExclusiveGroup(true);
            AclUtil.grant(config, defaults, "create", this.admin);
            config.commit(md);
        }
    }
}

