/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.Strings;
import com.google.gerrit.server.config.ConfigSection;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.schema.BaseDataSourceType;
import com.google.gerrit.server.schema.JdbcUtil;
import com.google.gerrit.server.schema.ScriptRunner;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.lib.Config;

class HANA
extends BaseDataSourceType {
    private Config cfg;

    @Inject
    HANA(@GerritServerConfig Config cfg) {
        super("com.sap.db.jdbc.Driver");
        this.cfg = cfg;
    }

    @Override
    public String getUrl() {
        StringBuilder b = new StringBuilder();
        ConfigSection dbs = new ConfigSection(this.cfg, "database");
        b.append("jdbc:sap://");
        b.append(JdbcUtil.hostname(dbs.required("hostname")));
        b.append(JdbcUtil.port(dbs.optional("port")));
        String database = dbs.optional("database");
        if (!Strings.isNullOrEmpty(database)) {
            b.append("?databaseName=").append(database);
        }
        return b.toString();
    }

    @Override
    public ScriptRunner getIndexScript() throws IOException {
        return ScriptRunner.NOOP;
    }
}

