/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.server.change.AccountPatchReviewStore;
import com.google.gerrit.server.schema.JdbcAccountPatchReviewStore;
import com.google.gwtorm.jdbc.SimpleDataSource;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class InMemoryAccountPatchReviewStore
extends JdbcAccountPatchReviewStore {
    @VisibleForTesting
    private InMemoryAccountPatchReviewStore() {
        super(InMemoryAccountPatchReviewStore.newDataSource());
    }

    private static synchronized DataSource newDataSource() {
        Properties p = new Properties();
        p.setProperty("driver", "org.h2.Driver");
        p.setProperty("url", "jdbc:h2:mem:account_patch_reviews;DB_CLOSE_DELAY=-1");
        try {
            return new SimpleDataSource(p);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to create test datasource", e);
        }
    }

    @VisibleForTesting
    public static class Module
    extends LifecycleModule {
        @Override
        protected void configure() {
            InMemoryAccountPatchReviewStore inMemoryStore = new InMemoryAccountPatchReviewStore();
            DynamicItem.bind(this.binder(), AccountPatchReviewStore.class).toInstance(inMemoryStore);
            this.listener().toInstance(inMemoryStore);
        }
    }
}

