/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_116;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;

public class Schema_117
extends SchemaVersion {
    @Inject
    Schema_117(Provider<Schema_116> prior) {
        super(prior);
    }

    @Override
    protected void preUpdateSchema(ReviewDb db) throws OrmException, SQLException {
        JdbcSchema schema = (JdbcSchema)((Object)db);
        Connection connection = schema.getConnection();
        String tableName = "patch_sets";
        String oldColumnName = "push_certficate";
        String newColumnName = "push_certificate";
        Set<String> columns = schema.getDialect().listColumns(connection, tableName);
        if (columns.contains(oldColumnName)) {
            Schema_117.renameColumn(db, tableName, oldColumnName, newColumnName);
        }
        try (Statement stmt = schema.getConnection().createStatement();){
            stmt.execute("ALTER TABLE " + tableName + " MODIFY " + newColumnName + " clob");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

