/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.registration.PrivateInternals_DynamicTypes;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.server.DynamicOptions;
import com.google.gerrit.server.PeerDaemonUser;
import com.google.gerrit.server.RemotePeer;
import com.google.gerrit.server.config.GerritRequestModule;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gerrit.server.git.receive.AsyncReceiveCommits;
import com.google.gerrit.server.plugins.ModuleGenerator;
import com.google.gerrit.server.plugins.ReloadPluginListener;
import com.google.gerrit.server.plugins.StartPluginListener;
import com.google.gerrit.server.ssh.SshInfo;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.gerrit.sshd.AliasCommandProvider;
import com.google.gerrit.sshd.CachingPublicKeyAuthenticator;
import com.google.gerrit.sshd.CommandExecutor;
import com.google.gerrit.sshd.CommandExecutorProvider;
import com.google.gerrit.sshd.CommandExecutorQueueProvider;
import com.google.gerrit.sshd.CommandFactoryProvider;
import com.google.gerrit.sshd.CommandName;
import com.google.gerrit.sshd.Commands;
import com.google.gerrit.sshd.DispatchCommand;
import com.google.gerrit.sshd.DispatchCommandProvider;
import com.google.gerrit.sshd.GerritGSSAuthenticator;
import com.google.gerrit.sshd.SshAutoRegisterModuleGenerator;
import com.google.gerrit.sshd.SshCreateCommandInterceptor;
import com.google.gerrit.sshd.SshDaemon;
import com.google.gerrit.sshd.SshExecuteCommandInterceptor;
import com.google.gerrit.sshd.SshLog;
import com.google.gerrit.sshd.SshPluginStarterCallback;
import com.google.gerrit.sshd.SshRemotePeerProvider;
import com.google.gerrit.sshd.SshScope;
import com.google.gerrit.sshd.SshSession;
import com.google.gerrit.sshd.StreamCommandExecutor;
import com.google.gerrit.sshd.StreamCommandExecutorProvider;
import com.google.gerrit.sshd.commands.QueryShell;
import com.google.inject.Inject;
import com.google.inject.Scopes;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.servlet.RequestScoped;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.eclipse.jgit.lib.Config;

public class SshModule
extends LifecycleModule {
    private final Map<String, String> aliases = new HashMap<String, String>();

    @Inject
    SshModule(@GerritServerConfig Config cfg) {
        for (String name : cfg.getNames("ssh-alias", true)) {
            this.aliases.put(name, cfg.getString("ssh-alias", null, name));
        }
    }

    @Override
    protected void configure() {
        this.bindScope(RequestScoped.class, SshScope.REQUEST);
        this.bind(RequestScopePropagator.class).to(SshScope.Propagator.class);
        this.bind(SshScope.class).in(Scopes.SINGLETON);
        this.configureRequestScope();
        this.install(new AsyncReceiveCommits.Module());
        this.configureAliases();
        this.bind(SshLog.class);
        this.bind(SshInfo.class).to(SshDaemon.class).in(Scopes.SINGLETON);
        this.factory(DispatchCommand.Factory.class);
        this.factory(QueryShell.Factory.class);
        this.factory(PeerDaemonUser.Factory.class);
        this.bind(DispatchCommandProvider.class).annotatedWith(Commands.CMD_ROOT).toInstance(new DispatchCommandProvider(Commands.CMD_ROOT));
        this.bind(CommandFactoryProvider.class);
        this.bind(CommandFactory.class).toProvider(CommandFactoryProvider.class);
        this.bind(ScheduledThreadPoolExecutor.class).annotatedWith(StreamCommandExecutor.class).toProvider(StreamCommandExecutorProvider.class).in(Scopes.SINGLETON);
        this.bind(QueueProvider.class).to(CommandExecutorQueueProvider.class);
        this.bind(GSSAuthenticator.class).to(GerritGSSAuthenticator.class);
        this.bind(PublickeyAuthenticator.class).to(CachingPublicKeyAuthenticator.class);
        this.bind(ModuleGenerator.class).to(SshAutoRegisterModuleGenerator.class);
        this.bind(SshPluginStarterCallback.class);
        this.bind(StartPluginListener.class).annotatedWith(UniqueAnnotations.create()).to(SshPluginStarterCallback.class);
        this.bind(ReloadPluginListener.class).annotatedWith(UniqueAnnotations.create()).to(SshPluginStarterCallback.class);
        DynamicMap.mapOf(this.binder(), DynamicOptions.DynamicBean.class);
        DynamicItem.itemOf(this.binder(), SshCreateCommandInterceptor.class);
        DynamicSet.setOf(this.binder(), SshExecuteCommandInterceptor.class);
        this.listener().toInstance(PrivateInternals_DynamicTypes.registerInParentInjectors());
        this.listener().to(SshLog.class);
        this.listener().to(SshDaemon.class);
        this.listener().to(CommandFactoryProvider.class);
    }

    private void configureAliases() {
        CommandName gerrit = Commands.named("gerrit");
        for (Map.Entry<String, String> e : this.aliases.entrySet()) {
            String name = e.getKey();
            String[] dest = e.getValue().split("[ \\t]+");
            CommandName cmd = Commands.named(dest[0]);
            for (int i = 1; i < dest.length; ++i) {
                cmd = Commands.named(cmd, dest[i]);
            }
            this.bind(Commands.key(gerrit, name)).toProvider(new AliasCommandProvider(cmd));
        }
    }

    private void configureRequestScope() {
        this.bind(SshScope.Context.class).toProvider(SshScope.ContextProvider.class);
        this.bind(SshSession.class).toProvider(SshScope.SshSessionProvider.class).in(SshScope.REQUEST);
        this.bind(SocketAddress.class).annotatedWith(RemotePeer.class).toProvider(SshRemotePeerProvider.class).in(SshScope.REQUEST);
        this.bind(ScheduledThreadPoolExecutor.class).annotatedWith(CommandExecutor.class).toProvider(CommandExecutorProvider.class).in(SshScope.REQUEST);
        this.install(new GerritRequestModule());
    }
}

