/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Optional;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.conformance.CheckConformance;
import com.google.template.soy.incrementaldomsrc.IncrementalDomSrcModule;
import com.google.template.soy.jbcsrc.api.SoySauceImpl;
import com.google.template.soy.jssrc.internal.JsSrcModule;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.msgs.SoyMsgPlugin;
import com.google.template.soy.parsepasses.contextautoesc.ContextualAutoescaper;
import com.google.template.soy.passes.SharedPassesModule;
import com.google.template.soy.pysrc.internal.PySrcModule;
import com.google.template.soy.shared.internal.SharedModule;
import com.google.template.soy.tofu.internal.TofuModule;
import com.google.template.soy.types.SoyTypeOps;
import com.google.template.soy.types.SoyTypeProvider;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.xliffmsgplugin.XliffMsgPlugin;
import javax.inject.Singleton;

public final class SoyModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.install(new TofuModule());
        this.install(new JsSrcModule());
        this.install(new PySrcModule());
        this.install(new IncrementalDomSrcModule());
        this.install(new SharedPassesModule());
        this.install(new SharedModule());
        Multibinder.newSetBinder(this.binder(), SoyTypeProvider.class);
        this.bind(SoyTypeRegistry.class).in(Singleton.class);
        this.bind(ContextualAutoescaper.class);
        this.bind(SoyTypeOps.class);
        this.bind(SoySauceImpl.Factory.class);
        OptionalBinder.newOptionalBinder(this.binder(), CheckConformance.class);
        OptionalBinder.newOptionalBinder(this.binder(), SoyMsgPlugin.class);
    }

    @Provides
    SoyMsgBundleHandler provideHandler(Optional<SoyMsgPlugin> plugin) {
        if (plugin.isPresent()) {
            return new SoyMsgBundleHandler(plugin.get());
        }
        return new SoyMsgBundleHandler(new XliffMsgPlugin());
    }

    @Provides
    SoyFileSet.Builder provideBuilder(SoyFileSet.CoreDependencies coreDeps) {
        return new SoyFileSet.Builder(coreDeps);
    }

    public int hashCode() {
        return SoyModule.class.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof SoyModule;
    }
}

