/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.SoyNode;

public final class CallParamValueNode
extends CallParamNode
implements SoyNode.ExprHolderNode {
    private static final SoyErrorKind SELF_ENDING_TAG_WITHOUT_VALUE = SoyErrorKind.of("A ''param'' tag should be self-ending (with a trailing ''/'') if and only if it also contains a value (invalid tag is '{'param {0} /'}').");
    private static final SoyErrorKind SELF_ENDING_TAG_WITH_KIND_ATTRIBUTE = SoyErrorKind.of("The ''kind'' attribute is not allowed on self-ending ''param'' tags (invalid tag is '{'param {0} /'}').");
    private final String key;
    private final ExprRootNode valueExpr;

    private CallParamValueNode(int id, SourceLocation sourceLocation, String key, ExprRootNode valueExpr, String commandText) {
        super(id, sourceLocation, commandText);
        this.key = Preconditions.checkNotNull(key);
        this.valueExpr = Preconditions.checkNotNull(valueExpr);
    }

    private CallParamValueNode(CallParamValueNode orig, CopyState copyState) {
        super(orig, copyState);
        this.key = orig.key;
        this.valueExpr = orig.valueExpr.copy(copyState);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_PARAM_VALUE_NODE;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String getExprText() {
        return this.valueExpr.toSourceString();
    }

    public ExprRootNode getExpr() {
        return this.valueExpr;
    }

    @Override
    public String getTagString() {
        return this.buildTagStringHelper(true);
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of(this.valueExpr);
    }

    @Override
    public CallParamValueNode copy(CopyState copyState) {
        return new CallParamValueNode(this, copyState);
    }

    public static final class Builder
    extends CallParamNode.Builder {
        private static CallParamValueNode error() {
            return new CallParamValueNode(-1, SourceLocation.UNKNOWN, "error", new ExprRootNode(new IntegerNode(1L, SourceLocation.UNKNOWN)), "error: error");
        }

        public Builder(int id, CallParamNode.CommandTextParseResult parseResult, SourceLocation sourceLocation) {
            super(id, parseResult, sourceLocation);
        }

        public CallParamValueNode build(ErrorReporter.Checkpoint checkpoint, ErrorReporter errorReporter) {
            if (this.parseResult.valueExpr == null) {
                errorReporter.report(this.sourceLocation, SELF_ENDING_TAG_WITHOUT_VALUE, this.parseResult.originalCommantText);
            }
            if (this.parseResult.contentKind != null) {
                errorReporter.report(this.sourceLocation, SELF_ENDING_TAG_WITH_KIND_ATTRIBUTE, this.parseResult.originalCommantText);
            }
            if (errorReporter.errorsSince(checkpoint)) {
                return Builder.error();
            }
            return new CallParamValueNode(this.id, this.sourceLocation, this.parseResult.key, this.parseResult.valueExpr, this.parseResult.originalCommantText);
        }
    }
}

