/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.HashtableOfTerm;
import com.googlecode.prolog_cafe.lang.InternalDatabase;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.PrologClassLoader;
import com.googlecode.prolog_cafe.lang.PrologControl;
import com.googlecode.prolog_cafe.lang.Term;
import java.util.Map;

public class PrologMachineCopy {
    protected final PrologClassLoader pcl;
    protected final HashtableOfTerm hashManager;
    protected final InternalDatabase internalDB;

    public static PrologMachineCopy save(PrologControl prologControl) {
        return new PrologMachineCopy(prologControl.engine);
    }

    public static PrologMachineCopy save(Prolog prolog) {
        return new PrologMachineCopy(prolog);
    }

    private PrologMachineCopy(Prolog prolog) {
        this.pcl = prolog.pcl;
        try {
            prolog.copyHash.clear();
            this.hashManager = PrologMachineCopy.copyDeep(prolog, prolog.hashManager);
            this.internalDB = new InternalDatabase(prolog, prolog.internalDB, true);
        }
        finally {
            prolog.copyHash.clear();
        }
    }

    private static HashtableOfTerm copyDeep(Prolog prolog, HashtableOfTerm hashtableOfTerm) {
        HashtableOfTerm hashtableOfTerm2 = new HashtableOfTerm();
        for (Map.Entry entry : hashtableOfTerm.entrySet()) {
            Term term = ((Term)entry.getValue()).copy(prolog);
            if (term instanceof JavaObjectTerm) {
                JavaObjectTerm javaObjectTerm = (JavaObjectTerm)term;
                if (javaObjectTerm.obj instanceof HashtableOfTerm) {
                    term = new JavaObjectTerm(PrologMachineCopy.copyDeep(prolog, (HashtableOfTerm)javaObjectTerm.obj));
                }
            }
            hashtableOfTerm2.put(((Term)entry.getKey()).copy(prolog), term);
        }
        return hashtableOfTerm2;
    }

    static HashtableOfTerm copyShallow(HashtableOfTerm hashtableOfTerm) {
        HashtableOfTerm hashtableOfTerm2 = new HashtableOfTerm();
        for (Map.Entry entry : hashtableOfTerm.entrySet()) {
            Term term = (Term)entry.getValue();
            if (term instanceof JavaObjectTerm) {
                JavaObjectTerm javaObjectTerm = (JavaObjectTerm)term;
                if (javaObjectTerm.obj instanceof HashtableOfTerm) {
                    term = new JavaObjectTerm(PrologMachineCopy.copyShallow((HashtableOfTerm)javaObjectTerm.obj));
                }
            }
            hashtableOfTerm2.put((Term)entry.getKey(), term);
        }
        return hashtableOfTerm2;
    }
}

