/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import org.parboiled.Node;
import org.parboiled.matchers.Matcher;
import org.parboiled.support.CharsEscaper;
import org.parboiled.trees.ImmutableTreeNode;

public final class DefaultParsingNode<V>
extends ImmutableTreeNode<Node<V>>
implements Node<V> {
    private final Matcher matcher;
    private final int startIndex;
    private final int endIndex;
    private final V value;
    private final boolean hasError;

    public DefaultParsingNode(Matcher matcher, List<Node<V>> children, int startIndex, int endIndex, @Nullable V value, boolean hasError) {
        super(children);
        this.matcher = Preconditions.checkNotNull(matcher, "matcher");
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.value = value;
        this.hasError = hasError;
    }

    @Override
    public Matcher getMatcher() {
        return this.matcher;
    }

    @Override
    public String getLabel() {
        return this.matcher.getLabel();
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.getLabel());
        if (this.value != null) {
            sb.append(", {").append(this.value).append('}');
        }
        sb.append(']');
        if (this.hasError) {
            sb.append('E');
        }
        return CharsEscaper.INSTANCE.escape(sb.toString());
    }
}

