/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger log = LoggerFactory.getLogger(Version.class);
    private static final String version = Version.loadVersion();

    public static String getVersion() {
        return version;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String loadVersion() {
        try (InputStream in = Version.class.getResourceAsStream("Version");){
            String string;
            if (in == null) {
                String string2 = "(dev)";
                return string2;
            }
            try (BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                String vs = r.readLine();
                if (vs != null && vs.startsWith("v")) {
                    vs = vs.substring(1);
                }
                if (vs != null && vs.isEmpty()) {
                    vs = null;
                }
                string = vs;
            }
            return string;
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
            return "(unknown version)";
        }
    }

    private Version() {
    }
}

