/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.registration;

import com.google.gerrit.extensions.registration.DynamicSetProvider;
import com.google.gerrit.extensions.registration.RegistrationHandle;
import com.google.gerrit.extensions.registration.ReloadableRegistrationHandle;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.name.Named;
import com.google.inject.util.Providers;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DynamicSet<T>
implements Iterable<T> {
    private final CopyOnWriteArrayList<AtomicReference<Provider<T>>> items;

    public static <T> void setOf(Binder binder, Class<T> member) {
        binder.disableCircularProxies();
        DynamicSet.setOf(binder, TypeLiteral.get(member));
    }

    public static <T> void setOf(Binder binder, TypeLiteral<T> member) {
        Key<?> key = Key.get(Types.newParameterizedType(DynamicSet.class, new Type[]{member.getType()}));
        binder.disableCircularProxies();
        binder.bind(key).toProvider((Provider<?>)new DynamicSetProvider<T>(member)).in(Scopes.SINGLETON);
    }

    public static <T> LinkedBindingBuilder<T> bind(Binder binder, Class<T> type) {
        binder.disableCircularProxies();
        return DynamicSet.bind(binder, TypeLiteral.get(type));
    }

    public static <T> LinkedBindingBuilder<T> bind(Binder binder, TypeLiteral<T> type) {
        binder.disableCircularProxies();
        return binder.bind(type).annotatedWith(UniqueAnnotations.create());
    }

    public static <T> LinkedBindingBuilder<T> bind(Binder binder, Class<T> type, Named name) {
        binder.disableCircularProxies();
        return DynamicSet.bind(binder, TypeLiteral.get(type));
    }

    public static <T> LinkedBindingBuilder<T> bind(Binder binder, TypeLiteral<T> type, Named name) {
        binder.disableCircularProxies();
        return binder.bind(type).annotatedWith(name);
    }

    public static <T> DynamicSet<T> emptySet() {
        return new DynamicSet<T>(Collections.emptySet());
    }

    DynamicSet(Collection<AtomicReference<Provider<T>>> base) {
        this.items = new CopyOnWriteArrayList<AtomicReference<Provider<T>>>(base);
    }

    public DynamicSet() {
        this(Collections.emptySet());
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<AtomicReference<Provider<T>>> itr = this.items.iterator();
        return new Iterator<T>(){
            private T next;

            @Override
            public boolean hasNext() {
                while (this.next == null && itr.hasNext()) {
                    Provider p = (Provider)((AtomicReference)itr.next()).get();
                    if (p == null) continue;
                    try {
                        this.next = p.get();
                    }
                    catch (RuntimeException runtimeException) {}
                }
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Object result = this.next;
                    this.next = null;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean contains(T item) {
        for (T candidate : this) {
            if (candidate != item) continue;
            return true;
        }
        return false;
    }

    public RegistrationHandle add(T item) {
        return this.add(Providers.of(item));
    }

    public RegistrationHandle add(final Provider<T> item) {
        final AtomicReference<Provider<T>> ref = new AtomicReference<Provider<T>>(item);
        this.items.add(ref);
        return new RegistrationHandle(){

            @Override
            public void remove() {
                if (ref.compareAndSet(item, null)) {
                    DynamicSet.this.items.remove(ref);
                }
            }
        };
    }

    public ReloadableRegistrationHandle<T> add(Key<T> key, Provider<T> item) {
        AtomicReference<Provider<T>> ref = new AtomicReference<Provider<T>>(item);
        this.items.add(ref);
        return new ReloadableHandle(ref, key, item);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    private class ReloadableHandle
    implements ReloadableRegistrationHandle<T> {
        private final AtomicReference<Provider<T>> ref;
        private final Key<T> key;
        private final Provider<T> item;

        ReloadableHandle(AtomicReference<Provider<T>> ref, Key<T> key, Provider<T> item) {
            this.ref = ref;
            this.key = key;
            this.item = item;
        }

        @Override
        public void remove() {
            if (this.ref.compareAndSet(this.item, null)) {
                DynamicSet.this.items.remove(this.ref);
            }
        }

        @Override
        public Key<T> getKey() {
            return this.key;
        }

        @Override
        public ReloadableHandle replace(Key<T> newKey, Provider<T> newItem) {
            if (this.ref.compareAndSet(this.item, newItem)) {
                return new ReloadableHandle(this.ref, newKey, newItem);
            }
            return null;
        }
    }
}

