/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.cache.Cache;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.httpd.CacheBasedWebSession;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.httpd.WebSessionManager;
import com.google.gerrit.httpd.WebSessionManagerFactory;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.config.AuthConfig;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Named;
import com.google.inject.servlet.RequestScoped;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@RequestScoped
public class H2CacheBasedWebSession
extends CacheBasedWebSession {
    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.persist("web_sessions", String.class, WebSessionManager.Val.class).maximumWeight(1024L).expireAfterWrite(CacheBasedWebSession.MAX_AGE_MINUTES, TimeUnit.MINUTES);
                this.install(new FactoryModuleBuilder().build(WebSessionManagerFactory.class));
                DynamicItem.itemOf(this.binder(), WebSession.class);
                DynamicItem.bind(this.binder(), WebSession.class).to(H2CacheBasedWebSession.class).in(RequestScoped.class);
            }
        };
    }

    @Inject
    H2CacheBasedWebSession(HttpServletRequest request, @Nullable HttpServletResponse response, WebSessionManagerFactory managerFactory, @Named(value="web_sessions") Cache<String, WebSessionManager.Val> cache, AuthConfig authConfig, Provider<AnonymousUser> anonymousProvider, IdentifiedUser.RequestFactory identified) {
        super(request, response, managerFactory.create(cache), authConfig, anonymousProvider, identified);
    }
}

