/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.plugins;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gerrit.extensions.annotations.Export;
import com.google.gerrit.server.plugins.AutoRegisterUtil;
import com.google.gerrit.server.plugins.InvalidPluginException;
import com.google.gerrit.server.plugins.ModuleGenerator;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.servlet.ServletModule;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;

class HttpAutoRegisterModuleGenerator
extends ServletModule
implements ModuleGenerator {
    private final Map<String, Class<HttpServlet>> serve = new HashMap<String, Class<HttpServlet>>();
    private final ListMultimap<TypeLiteral<?>, Class<?>> listeners = LinkedListMultimap.create();

    HttpAutoRegisterModuleGenerator() {
    }

    @Override
    protected void configureServlets() {
        for (Map.Entry<String, Class<HttpServlet>> entry : this.serve.entrySet()) {
            this.bind(entry.getValue()).in(Scopes.SINGLETON);
            this.serve(entry.getKey(), new String[0]).with(entry.getValue());
        }
        for (Map.Entry<String, Class<HttpServlet>> entry : this.listeners.entries()) {
            TypeLiteral type = (TypeLiteral)((Object)entry.getKey());
            Class<Object> impl = entry.getValue();
            Annotation n = AutoRegisterUtil.calculateBindAnnotation(impl);
            this.bind(type).annotatedWith(n).to(impl);
        }
    }

    @Override
    public void setPluginName(String name) {
    }

    @Override
    public void export(Export export, Class<?> type) throws InvalidPluginException {
        if (HttpServlet.class.isAssignableFrom(type)) {
            Class<HttpServlet> old = this.serve.get(export.value());
            if (old != null) {
                throw new InvalidPluginException(String.format("@Export(\"%s\") has duplicate bindings:\n  %s\n  %s", export.value(), old.getName(), type.getName()));
            }
        } else {
            throw new InvalidPluginException(String.format("Class %s with @Export(\"%s\") must extend %s", type.getName(), export.value(), HttpServlet.class.getName()));
        }
        this.serve.put(export.value(), type);
    }

    @Override
    public void listen(TypeLiteral<?> tl, Class<?> clazz) {
        this.listeners.put(tl, clazz);
    }

    @Override
    public Module create() throws InvalidPluginException {
        return this;
    }
}

