/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.restapi;

import com.google.common.base.Strings;
import com.google.gerrit.httpd.restapi.RestApiServlet;
import com.google.gerrit.metrics.Counter1;
import com.google.gerrit.metrics.Counter2;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.Field;
import com.google.gerrit.metrics.Histogram1;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.metrics.Timer1;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class RestApiMetrics {
    private static final String[] PKGS = new String[]{"com.google.gerrit.server.", "com.google.gerrit."};
    final Counter1<String> count;
    final Counter2<String, Integer> errorCount;
    final Timer1<String> serverLatency;
    final Histogram1<String> responseBytes;

    @Inject
    RestApiMetrics(MetricMaker metrics) {
        Field<String> view = Field.ofString("view", "view implementation class");
        this.count = metrics.newCounter("http/server/rest_api/count", new Description("REST API calls by view").setRate(), view);
        this.errorCount = metrics.newCounter("http/server/rest_api/error_count", new Description("REST API errors by view").setRate(), view, Field.ofInteger("error_code", "HTTP status code"));
        this.serverLatency = metrics.newTimer("http/server/rest_api/server_latency", new Description("REST API call latency by view").setCumulative().setUnit("milliseconds"), view);
        this.responseBytes = metrics.newHistogram("http/server/rest_api/response_bytes", new Description("Size of response on network (may be gzip compressed)").setCumulative().setUnit("bytes"), view);
    }

    String view(RestApiServlet.ViewData viewData) {
        String impl = viewData.view.getClass().getName().replace('$', '.');
        for (String p : PKGS) {
            if (!impl.startsWith(p)) continue;
            impl = impl.substring(p.length());
            break;
        }
        if (!Strings.isNullOrEmpty(viewData.pluginName) && !"gerrit".equals(viewData.pluginName)) {
            impl = viewData.pluginName + '-' + impl;
        }
        return impl;
    }
}

