/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.audit.AuditService;
import com.google.gerrit.audit.RpcAuditEvent;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.audit.Audit;
import com.google.gerrit.common.auth.SignInRequired;
import com.google.gerrit.common.errors.NotSignedInException;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.httpd.rpc.AuditedHttpServletResponse;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.CurrentUser;
import com.google.gson.GsonBuilder;
import com.google.gwtjsonrpc.common.RemoteJsonService;
import com.google.gwtjsonrpc.server.ActiveCall;
import com.google.gwtjsonrpc.server.JsonServlet;
import com.google.gwtjsonrpc.server.MethodHandle;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GerritJsonServlet
extends JsonServlet<GerritCall> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(GerritJsonServlet.class);
    private static final ThreadLocal<GerritCall> currentCall = new ThreadLocal();
    private static final ThreadLocal<MethodHandle> currentMethod = new ThreadLocal();
    private final DynamicItem<WebSession> session;
    private final RemoteJsonService service;
    private final AuditService audit;

    @Inject
    GerritJsonServlet(DynamicItem<WebSession> w, RemoteJsonService s, AuditService a) {
        this.session = w;
        this.service = s;
        this.audit = a;
    }

    @Override
    protected GerritCall createActiveCall(HttpServletRequest req, HttpServletResponse rsp) {
        GerritCall call = new GerritCall(this.session.get(), req, new AuditedHttpServletResponse(rsp));
        currentCall.set(call);
        return call;
    }

    @Override
    protected GsonBuilder createGsonBuilder() {
        return GerritJsonServlet.gerritDefaultGsonBuilder();
    }

    private static GsonBuilder gerritDefaultGsonBuilder() {
        GsonBuilder g = GerritJsonServlet.defaultGsonBuilder();
        g.registerTypeAdapter((Type)((Object)Edit.class), new EditDeserializer());
        return g;
    }

    @Override
    protected void preInvoke(GerritCall call) {
        super.preInvoke(call);
        if (call.isComplete()) {
            return;
        }
        if (!(call.getMethod().getAnnotation(SignInRequired.class) == null || call.requireXsrfValid() && this.session.get().isSignedIn())) {
            call.onFailure(new NotSignedInException());
        }
    }

    @Override
    protected Object createServiceHandle() {
        return this.service;
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            super.service(req, resp);
        }
        finally {
            this.audit();
            currentCall.set(null);
        }
    }

    private void audit() {
        try {
            GerritCall call = currentCall.get();
            MethodHandle method = call.getMethod();
            if (method == null) {
                return;
            }
            Audit note = method.getAnnotation(Audit.class);
            if (note != null) {
                String sid = call.getWebSession().getSessionId();
                CurrentUser username = call.getWebSession().getUser();
                ListMultimap<String, ?> args = this.extractParams(note, call);
                String what = this.extractWhat(note, call);
                Object result = call.getResult();
                this.audit.dispatch(new RpcAuditEvent(sid, username, what, call.getWhen(), args, call.getHttpServletRequest().getMethod(), call.getHttpServletRequest().getMethod(), ((AuditedHttpServletResponse)call.getHttpServletResponse()).getStatus(), result));
            }
        }
        catch (Throwable all) {
            log.error("Unable to log the call", all);
        }
    }

    private ListMultimap<String, ?> extractParams(Audit note, GerritCall call) {
        Multimap args = MultimapBuilder.hashKeys().arrayListValues().build();
        Object[] params = call.getParams();
        for (int i = 0; i < params.length; ++i) {
            args.put("$" + i, params[i]);
        }
        for (int idx : note.obfuscate()) {
            args.removeAll("$" + idx);
            args.put("$" + idx, "*****");
        }
        return args;
    }

    private String extractWhat(Audit note, GerritCall call) {
        Class<?> methodClass = call.getMethodClass();
        String methodClassName = methodClass != null ? methodClass.getName() : "<UNKNOWN_CLASS>";
        methodClassName = methodClassName.substring(methodClassName.lastIndexOf(".") + 1);
        String what = note.action();
        if (what.length() == 0) {
            what = call.getMethod().getName();
        }
        return methodClassName + "." + what;
    }

    static class GerritCall
    extends ActiveCall {
        private final WebSession session;
        private final long when;
        private static final Field resultField = GerritCall.getPrivateField(ActiveCall.class, "result");
        private static final Field methodField = GerritCall.getPrivateField(MethodHandle.class, "method");

        private static Field getPrivateField(Class<?> clazz, String fieldName) {
            Field declaredField = null;
            try {
                declaredField = clazz.getDeclaredField(fieldName);
                declaredField.setAccessible(true);
            }
            catch (Exception e) {
                log.error("Unable to expose RPS/JSON result field");
            }
            return declaredField;
        }

        public Class<?> getMethodClass() {
            if (methodField == null) {
                return null;
            }
            try {
                Method method = (Method)methodField.get(this.getMethod());
                return method.getDeclaringClass();
            }
            catch (IllegalArgumentException e) {
                log.error("Cannot access result field");
            }
            catch (IllegalAccessException e) {
                log.error("No permissions to access result field");
            }
            return null;
        }

        public Object getResult() {
            if (resultField == null) {
                return null;
            }
            try {
                return resultField.get(this);
            }
            catch (IllegalArgumentException e) {
                log.error("Cannot access result field");
            }
            catch (IllegalAccessException e) {
                log.error("No permissions to access result field");
            }
            return null;
        }

        GerritCall(WebSession session, HttpServletRequest i, HttpServletResponse o) {
            super(i, o);
            this.session = session;
            this.when = TimeUtil.nowMs();
        }

        @Override
        public MethodHandle getMethod() {
            if (currentMethod.get() == null) {
                return super.getMethod();
            }
            return (MethodHandle)currentMethod.get();
        }

        @Override
        public void onFailure(Throwable error) {
            if (error instanceof IllegalArgumentException || error instanceof IllegalStateException) {
                super.onFailure(error);
            } else if (error instanceof OrmException || error instanceof RuntimeException) {
                this.onInternalFailure(error);
            } else {
                super.onFailure(error);
            }
        }

        @Override
        public boolean xsrfValidate() {
            String keyIn = this.getXsrfKeyIn();
            if (keyIn == null || "".equals(keyIn)) {
                return !this.session.isSignedIn();
            }
            if (this.session.isSignedIn() && this.session.isValidXGerritAuth(keyIn)) {
                this.session.getUser().setAccessPath(AccessPath.JSON_RPC);
                return true;
            }
            return false;
        }

        public WebSession getWebSession() {
            return this.session;
        }

        public long getWhen() {
            return this.when;
        }

        public long getElapsed() {
            return TimeUtil.nowMs() - this.when;
        }
    }
}

