/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.index.query;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.index.Index;
import com.google.gerrit.index.IndexCollection;
import com.google.gerrit.index.IndexConfig;
import com.google.gerrit.index.IndexRewriter;
import com.google.gerrit.index.QueryOptions;
import com.google.gerrit.index.SchemaDefinitions;
import com.google.gerrit.index.query.DataSource;
import com.google.gerrit.index.query.LimitPredicate;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.index.query.QueryResult;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.Field;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.metrics.Timer1;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.OrmRuntimeException;
import com.google.gwtorm.server.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntSupplier;
import java.util.stream.IntStream;

public abstract class QueryProcessor<T> {
    private final Metrics metrics;
    private final SchemaDefinitions<T> schemaDef;
    private final IndexConfig indexConfig;
    private final IndexCollection<?, T, ? extends Index<?, T>> indexes;
    private final IndexRewriter<T> rewriter;
    private final String limitField;
    private final IntSupplier permittedLimit;
    private final AtomicBoolean used;
    protected int start;
    private boolean enforceVisibility = true;
    private int userProvidedLimit;
    private Set<String> requestedFields;

    protected QueryProcessor(MetricMaker metricMaker, SchemaDefinitions<T> schemaDef, IndexConfig indexConfig, IndexCollection<?, T, ? extends Index<?, T>> indexes, IndexRewriter<T> rewriter, String limitField, IntSupplier permittedLimit) {
        this.metrics = new Metrics(metricMaker);
        this.schemaDef = schemaDef;
        this.indexConfig = indexConfig;
        this.indexes = indexes;
        this.rewriter = rewriter;
        this.limitField = limitField;
        this.permittedLimit = permittedLimit;
        this.used = new AtomicBoolean(false);
    }

    public QueryProcessor<T> setStart(int n) {
        this.start = n;
        return this;
    }

    public QueryProcessor<T> enforceVisibility(boolean enforce) {
        this.enforceVisibility = enforce;
        return this;
    }

    public QueryProcessor<T> setUserProvidedLimit(int n) {
        this.userProvidedLimit = n;
        return this;
    }

    public QueryProcessor<T> setRequestedFields(Set<String> fields) {
        this.requestedFields = fields;
        return this;
    }

    public QueryResult<T> query(Predicate<T> query) throws OrmException, QueryParseException {
        return this.query(ImmutableList.of(query)).get(0);
    }

    public List<QueryResult<T>> query(List<Predicate<T>> queries) throws OrmException, QueryParseException {
        try {
            return this.query(null, queries);
        }
        catch (OrmRuntimeException e) {
            throw new OrmException(e.getMessage(), e);
        }
        catch (OrmException e) {
            if (e.getCause() != null) {
                Throwables.throwIfInstanceOf(e.getCause(), QueryParseException.class);
            }
            throw e;
        }
    }

    private List<QueryResult<T>> query(@Nullable List<String> queryStrings, List<Predicate<T>> queries) throws OrmException, QueryParseException {
        long startNanos = System.nanoTime();
        Preconditions.checkState(!this.used.getAndSet(true), "%s has already been used", (Object)this.getClass().getSimpleName());
        int cnt = queries.size();
        if (queryStrings != null) {
            int qs = queryStrings.size();
            Preconditions.checkArgument(qs == cnt, "got %s query strings but %s predicates", qs, cnt);
        }
        if (cnt == 0) {
            return ImmutableList.of();
        }
        if (this.isDisabled()) {
            return QueryProcessor.disabledResults(queryStrings, queries);
        }
        ArrayList<Integer> limits = new ArrayList<Integer>(cnt);
        ArrayList<Predicate<T>> predicates = new ArrayList<Predicate<T>>(cnt);
        ArrayList<DataSource> sources = new ArrayList<DataSource>(cnt);
        for (Predicate<T> predicate : queries) {
            int page;
            int limit = this.getEffectiveLimit(predicate);
            limits.add(limit);
            if (limit == this.getBackendSupportedLimit()) {
                --limit;
            }
            if ((page = this.start / limit + 1) > this.indexConfig.maxPages()) {
                throw new QueryParseException("Cannot go beyond page " + this.indexConfig.maxPages() + " of results");
            }
            QueryOptions opts = this.createOptions(this.indexConfig, this.start, limit + 1, this.getRequestedFields());
            Predicate<T> pred = this.rewriter.rewrite(predicate, opts);
            if (this.enforceVisibility) {
                pred = this.enforceVisibility(pred);
            }
            predicates.add(pred);
            DataSource s = (DataSource)((Object)pred);
            sources.add(s);
        }
        ArrayList matches = new ArrayList(cnt);
        for (DataSource s : sources) {
            matches.add(s.read());
        }
        ArrayList<QueryResult<T>> arrayList = new ArrayList<QueryResult<T>>(cnt);
        for (int i = 0; i < cnt; ++i) {
            arrayList.add(QueryResult.create(queryStrings != null ? queryStrings.get(i) : null, (Predicate)predicates.get(i), (Integer)limits.get(i), ((ResultSet)matches.get(i)).toList()));
        }
        this.metrics.executionTime.record(this.schemaDef.getName(), System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
        return arrayList;
    }

    private static <T> ImmutableList<QueryResult<T>> disabledResults(List<String> queryStrings, List<Predicate<T>> queries) {
        return IntStream.range(0, queries.size()).mapToObj(i -> QueryResult.create(queryStrings != null ? (String)queryStrings.get(i) : null, (Predicate)queries.get(i), 0, ImmutableList.of())).collect(ImmutableList.toImmutableList());
    }

    protected QueryOptions createOptions(IndexConfig indexConfig, int start, int limit, Set<String> requestedFields) {
        return QueryOptions.create(indexConfig, start, limit, requestedFields);
    }

    protected abstract Predicate<T> enforceVisibility(Predicate<T> var1);

    private Set<String> getRequestedFields() {
        if (this.requestedFields != null) {
            return this.requestedFields;
        }
        Index<?, T> index = this.indexes.getSearchIndex();
        return index != null ? index.getSchema().getStoredFields().keySet() : ImmutableSet.of();
    }

    public boolean isDisabled() {
        return this.enforceVisibility && this.getPermittedLimit() <= 0;
    }

    private int getPermittedLimit() {
        return this.enforceVisibility ? this.permittedLimit.getAsInt() : Integer.MAX_VALUE;
    }

    private int getBackendSupportedLimit() {
        return this.indexConfig.maxLimit();
    }

    private int getEffectiveLimit(Predicate<T> p) {
        int result;
        Integer limitFromPredicate;
        ArrayList<Integer> possibleLimits = new ArrayList<Integer>(4);
        possibleLimits.add(this.getBackendSupportedLimit());
        possibleLimits.add(this.getPermittedLimit());
        if (this.userProvidedLimit > 0) {
            possibleLimits.add(this.userProvidedLimit);
        }
        if (this.limitField != null && (limitFromPredicate = LimitPredicate.getLimit(this.limitField, p)) != null) {
            possibleLimits.add(limitFromPredicate);
        }
        Preconditions.checkState((result = ((Integer)Ordering.natural().min(possibleLimits)).intValue()) > 0, "effective limit should be positive");
        return result;
    }

    protected static class Metrics {
        final Timer1<String> executionTime;

        Metrics(MetricMaker metricMaker) {
            Field<String> index = Field.ofString("index", "index name");
            this.executionTime = metricMaker.newTimer("query/query_latency", new Description("Successful query latency, accumulated over the life of the process").setCumulative().setUnit("milliseconds"), index);
        }
    }
}

