/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.server.plugins.DelegatingClassLoader;
import com.google.gerrit.util.cli.CmdLineParser;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class DynamicOptions {
    protected static Map<ClassLoader, Map<ClassLoader, WeakReference<ClassLoader>>> mergedClByCls = Collections.synchronizedMap(new WeakHashMap());
    protected Object bean;
    protected Map<String, DynamicBean> beansByPlugin;
    protected Injector injector;

    public DynamicOptions(Object bean, Injector injector, DynamicMap<DynamicBean> dynamicBeans) {
        this.bean = bean;
        this.injector = injector;
        this.beansByPlugin = new HashMap<String, DynamicBean>();
        for (String plugin : dynamicBeans.plugins()) {
            Provider provider = (Provider)dynamicBeans.byPlugin(plugin).get(bean.getClass().getCanonicalName());
            if (provider == null) continue;
            this.beansByPlugin.put(plugin, this.getDynamicBean(bean, (DynamicBean)provider.get()));
        }
    }

    public DynamicBean getDynamicBean(Object bean, DynamicBean dynamicBean) {
        ClassLoader dynamicBeanCl;
        ClassLoader beanCl;
        ClassLoader coreCl = this.getClass().getClassLoader();
        ClassLoader loader = beanCl = bean.getClass().getClassLoader();
        if (beanCl != coreCl && beanCl != (dynamicBeanCl = dynamicBean.getClass().getClassLoader())) {
            loader = this.getMergedClassLoader(beanCl, dynamicBeanCl);
        }
        String className = null;
        if (dynamicBean instanceof ClassNameProvider) {
            className = ((ClassNameProvider)dynamicBean).getClassName();
        } else if (loader != beanCl) {
            className = dynamicBean.getClass().getCanonicalName();
        }
        if (className != null) {
            try {
                ArrayList<Module> modules = new ArrayList<Module>();
                Injector modulesInjector = this.injector;
                if (dynamicBean instanceof ModulesClassNamesProvider) {
                    modulesInjector = this.injector.createChildInjector(new Module[0]);
                    for (String moduleName : ((ModulesClassNamesProvider)dynamicBean).getModulesClassNames()) {
                        Class<?> mClass = loader.loadClass(moduleName);
                        modules.add((Module)modulesInjector.getInstance(mClass));
                    }
                }
                return (DynamicBean)modulesInjector.createChildInjector(modules).getInstance(loader.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return dynamicBean;
    }

    protected ClassLoader getMergedClassLoader(ClassLoader beanCl, ClassLoader dynamicBeanCl) {
        Map<ClassLoader, WeakReference<ClassLoader>> mergedClByCl = mergedClByCls.get(beanCl);
        if (mergedClByCl == null) {
            mergedClByCl = Collections.synchronizedMap(new WeakHashMap());
            mergedClByCls.put(beanCl, mergedClByCl);
        }
        WeakReference<ClassLoader> mergedClRef = mergedClByCl.get(dynamicBeanCl);
        ClassLoader mergedCl = null;
        if (mergedClRef != null) {
            mergedCl = (ClassLoader)mergedClRef.get();
        }
        if (mergedCl == null) {
            mergedCl = new DelegatingClassLoader(beanCl, dynamicBeanCl);
            mergedClByCl.put(dynamicBeanCl, new WeakReference<ClassLoader>(mergedCl));
        }
        return mergedCl;
    }

    public void parseDynamicBeans(CmdLineParser clp) {
        for (Map.Entry<String, DynamicBean> e : this.beansByPlugin.entrySet()) {
            clp.parseWithPrefix("--" + e.getKey(), e.getValue());
        }
    }

    public void setDynamicBeans() {
        if (this.bean instanceof BeanReceiver) {
            BeanReceiver receiver = (BeanReceiver)this.bean;
            for (Map.Entry<String, DynamicBean> e : this.beansByPlugin.entrySet()) {
                receiver.setDynamicBean(e.getKey(), e.getValue());
            }
        }
    }

    public void onBeanParseStart() {
        for (Map.Entry<String, DynamicBean> e : this.beansByPlugin.entrySet()) {
            DynamicBean instance = e.getValue();
            if (!(instance instanceof BeanParseListener)) continue;
            BeanParseListener listener = (BeanParseListener)instance;
            listener.onBeanParseStart(e.getKey(), this.bean);
        }
    }

    public void onBeanParseEnd() {
        for (Map.Entry<String, DynamicBean> e : this.beansByPlugin.entrySet()) {
            DynamicBean instance = e.getValue();
            if (!(instance instanceof BeanParseListener)) continue;
            BeanParseListener listener = (BeanParseListener)instance;
            listener.onBeanParseEnd(e.getKey(), this.bean);
        }
    }

    public static interface BeanReceiver {
        public void setDynamicBean(String var1, DynamicBean var2);
    }

    public static interface BeanParseListener
    extends DynamicBean {
        public void onBeanParseStart(String var1, Object var2);

        public void onBeanParseEnd(String var1, Object var2);
    }

    public static interface ModulesClassNamesProvider
    extends ClassNameProvider {
        public Iterable<String> getModulesClassNames();
    }

    public static interface ClassNameProvider
    extends DynamicBean {
        public String getClassName();
    }

    public static interface DynamicBean {
    }
}

