/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.common.GroupBaseInfo;
import com.google.gerrit.extensions.common.SuggestedReviewerInfo;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.index.query.QueryResult;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.metrics.Timer0;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.ReviewerRecommender;
import com.google.gerrit.server.account.AccountDirectory;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupMembers;
import com.google.gerrit.server.change.PostReviewers;
import com.google.gerrit.server.change.SuggestReviewers;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.account.AccountPredicates;
import com.google.gerrit.server.query.account.AccountQueryBuilder;
import com.google.gerrit.server.query.account.AccountQueryProcessor;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;

public class ReviewersUtil {
    private static final int CANDIDATE_LIST_MULTIPLIER = 2;
    private final AccountLoader accountLoader;
    private final AccountQueryBuilder accountQueryBuilder;
    private final Provider<AccountQueryProcessor> queryProvider;
    private final GroupBackend groupBackend;
    private final GroupMembers.Factory groupMembersFactory;
    private final Provider<CurrentUser> currentUser;
    private final ReviewerRecommender reviewerRecommender;
    private final Metrics metrics;

    @Inject
    ReviewersUtil(AccountLoader.Factory accountLoaderFactory, AccountQueryBuilder accountQueryBuilder, Provider<AccountQueryProcessor> queryProvider, GroupBackend groupBackend, GroupMembers.Factory groupMembersFactory, Provider<CurrentUser> currentUser, ReviewerRecommender reviewerRecommender, Metrics metrics) {
        EnumSet<AccountDirectory.FillOptions> fillOptions = EnumSet.of(AccountDirectory.FillOptions.SECONDARY_EMAILS);
        fillOptions.addAll(AccountLoader.DETAILED_OPTIONS);
        this.accountLoader = accountLoaderFactory.create(fillOptions);
        this.accountQueryBuilder = accountQueryBuilder;
        this.queryProvider = queryProvider;
        this.currentUser = currentUser;
        this.groupBackend = groupBackend;
        this.groupMembersFactory = groupMembersFactory;
        this.reviewerRecommender = reviewerRecommender;
        this.metrics = metrics;
    }

    public List<SuggestedReviewerInfo> suggestReviewers(ChangeNotes changeNotes, SuggestReviewers suggestReviewers, ProjectState projectState, VisibilityControl visibilityControl, boolean excludeGroups) throws IOException, OrmException, ConfigInvalidException {
        String query = suggestReviewers.getQuery();
        int limit = suggestReviewers.getLimit();
        if (!suggestReviewers.getSuggestAccounts()) {
            return Collections.emptyList();
        }
        ArrayList<Account.Id> candidateList = new ArrayList();
        if (!Strings.isNullOrEmpty(query)) {
            candidateList = this.suggestAccounts(suggestReviewers);
        }
        List<Account.Id> sortedRecommendations = this.recommendAccounts(changeNotes, suggestReviewers, projectState, candidateList);
        ArrayList<Account.Id> filteredRecommendations = new ArrayList<Account.Id>();
        try (Timer0.Context ctx = this.metrics.filterVisibility.start();){
            for (Account.Id reviewer : sortedRecommendations) {
                if (filteredRecommendations.size() >= limit) {
                    break;
                }
                if (!visibilityControl.isVisibleTo(reviewer)) continue;
                filteredRecommendations.add(reviewer);
            }
        }
        List<SuggestedReviewerInfo> suggestedReviewer = this.loadAccounts(filteredRecommendations);
        if (!excludeGroups && suggestedReviewer.size() < limit && !Strings.isNullOrEmpty(query)) {
            suggestedReviewer.addAll(this.suggestAccountGroups(suggestReviewers, projectState, visibilityControl, limit - suggestedReviewer.size()));
        }
        if (suggestedReviewer.size() <= limit) {
            return suggestedReviewer;
        }
        return suggestedReviewer.subList(0, limit);
    }

    private List<Account.Id> suggestAccounts(SuggestReviewers suggestReviewers) throws OrmException {
        try (Timer0.Context ctx = this.metrics.queryAccountsLatency.start();){
            QueryResult<AccountState> result = this.queryProvider.get().setUserProvidedLimit(suggestReviewers.getLimit() * 2).query(AccountPredicates.andActive(this.accountQueryBuilder.defaultQuery(suggestReviewers.getQuery())));
            List<Account.Id> list = result.entities().stream().map(a -> a.getAccount().getId()).collect(Collectors.toList());
            return list;
        }
    }

    private List<Account.Id> recommendAccounts(ChangeNotes changeNotes, SuggestReviewers suggestReviewers, ProjectState projectState, List<Account.Id> candidateList) throws OrmException, IOException, ConfigInvalidException {
        try (Timer0.Context ctx = this.metrics.recommendAccountsLatency.start();){
            List<Account.Id> list = this.reviewerRecommender.suggestReviewers(changeNotes, suggestReviewers, projectState, candidateList);
            return list;
        }
    }

    private List<SuggestedReviewerInfo> loadAccounts(List<Account.Id> accountIds) throws OrmException {
        try (Timer0.Context ctx = this.metrics.loadAccountsLatency.start();){
            List<SuggestedReviewerInfo> reviewer = accountIds.stream().map(this.accountLoader::get).filter(Objects::nonNull).map(a -> {
                SuggestedReviewerInfo info = new SuggestedReviewerInfo();
                info.account = a;
                info.count = 1;
                return info;
            }).collect(Collectors.toList());
            this.accountLoader.fill();
            List<SuggestedReviewerInfo> list = reviewer;
            return list;
        }
    }

    private List<SuggestedReviewerInfo> suggestAccountGroups(SuggestReviewers suggestReviewers, ProjectState projectState, VisibilityControl visibilityControl, int limit) throws OrmException, IOException {
        try (Timer0.Context ctx = this.metrics.queryGroupsLatency.start();){
            ArrayList<SuggestedReviewerInfo> groups = new ArrayList<SuggestedReviewerInfo>();
            for (GroupReference g : this.suggestAccountGroups(suggestReviewers, projectState)) {
                GroupAsReviewer result = this.suggestGroupAsReviewer(suggestReviewers, projectState.getProject(), g, visibilityControl);
                if (!result.allowed && !result.allowedWithConfirmation) continue;
                GroupBaseInfo info = new GroupBaseInfo();
                info.id = Url.encode(g.getUUID().get());
                info.name = g.getName();
                SuggestedReviewerInfo suggestedReviewerInfo = new SuggestedReviewerInfo();
                suggestedReviewerInfo.group = info;
                suggestedReviewerInfo.count = result.size;
                if (result.allowedWithConfirmation) {
                    suggestedReviewerInfo.confirm = true;
                }
                groups.add(suggestedReviewerInfo);
                if (groups.size() < limit) continue;
                break;
            }
            ArrayList<SuggestedReviewerInfo> arrayList = groups;
            return arrayList;
        }
    }

    private List<GroupReference> suggestAccountGroups(SuggestReviewers suggestReviewers, ProjectState projectState) {
        return this.groupBackend.suggest(suggestReviewers.getQuery(), projectState).stream().limit(suggestReviewers.getLimit()).collect(Collectors.toList());
    }

    private GroupAsReviewer suggestGroupAsReviewer(SuggestReviewers suggestReviewers, Project project, GroupReference group, VisibilityControl visibilityControl) throws OrmException, IOException {
        GroupAsReviewer result = new GroupAsReviewer();
        int maxAllowed = suggestReviewers.getMaxAllowed();
        int maxAllowedWithoutConfirmation = suggestReviewers.getMaxAllowedWithoutConfirmation();
        if (!PostReviewers.isLegalReviewerGroup(group.getUUID())) {
            return result;
        }
        try {
            Set<Account> members = this.groupMembersFactory.create(this.currentUser.get()).listAccounts(group.getUUID(), project.getNameKey());
            if (members.isEmpty()) {
                return result;
            }
            result.size = members.size();
            if (maxAllowed > 0 && result.size > maxAllowed) {
                return result;
            }
            boolean needsConfirmation = result.size > maxAllowedWithoutConfirmation;
            for (Account account : members) {
                if (!visibilityControl.isVisibleTo(account.getId())) continue;
                if (needsConfirmation) {
                    result.allowedWithConfirmation = true;
                } else {
                    result.allowed = true;
                }
                return result;
            }
        }
        catch (NoSuchGroupException e) {
            return result;
        }
        catch (NoSuchProjectException e) {
            return result;
        }
        return result;
    }

    private static class GroupAsReviewer {
        boolean allowed;
        boolean allowedWithConfirmation;
        int size;

        private GroupAsReviewer() {
        }
    }

    public static interface VisibilityControl {
        public boolean isVisibleTo(Account.Id var1) throws OrmException;
    }

    @Singleton
    private static class Metrics {
        final Timer0 queryAccountsLatency;
        final Timer0 recommendAccountsLatency;
        final Timer0 loadAccountsLatency;
        final Timer0 queryGroupsLatency;
        final Timer0 filterVisibility;

        @Inject
        Metrics(MetricMaker metricMaker) {
            this.queryAccountsLatency = metricMaker.newTimer("reviewer_suggestion/query_accounts", new Description("Latency for querying accounts for reviewer suggestion").setCumulative().setUnit("milliseconds"));
            this.recommendAccountsLatency = metricMaker.newTimer("reviewer_suggestion/recommend_accounts", new Description("Latency for recommending accounts for reviewer suggestion").setCumulative().setUnit("milliseconds"));
            this.loadAccountsLatency = metricMaker.newTimer("reviewer_suggestion/load_accounts", new Description("Latency for loading accounts for reviewer suggestion").setCumulative().setUnit("milliseconds"));
            this.queryGroupsLatency = metricMaker.newTimer("reviewer_suggestion/query_groups", new Description("Latency for querying groups for reviewer suggestion").setCumulative().setUnit("milliseconds"));
            this.filterVisibility = metricMaker.newTimer("reviewer_suggestion/filter_visibility", new Description("Latency for removing users that can't see the change").setCumulative().setUnit("milliseconds"));
        }
    }
}

