/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.api.access.GlobalOrPluginPermission;
import com.google.gerrit.extensions.api.access.PluginPermission;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GetCapabilities;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
class Capabilities
implements ChildCollection<AccountResource, AccountResource.Capability> {
    private final Provider<CurrentUser> self;
    private final PermissionBackend permissionBackend;
    private final DynamicMap<RestView<AccountResource.Capability>> views;
    private final Provider<GetCapabilities> get;

    @Inject
    Capabilities(Provider<CurrentUser> self, PermissionBackend permissionBackend, DynamicMap<RestView<AccountResource.Capability>> views, Provider<GetCapabilities> get) {
        this.self = self;
        this.permissionBackend = permissionBackend;
        this.views = views;
        this.get = get;
    }

    public GetCapabilities list() throws ResourceNotFoundException {
        return this.get.get();
    }

    @Override
    public AccountResource.Capability parse(AccountResource parent, IdString id) throws ResourceNotFoundException, AuthException, PermissionBackendException {
        IdentifiedUser target = parent.getUser();
        if (!this.self.get().hasSameAccountId(target)) {
            this.permissionBackend.user(this.self).check(GlobalPermission.ADMINISTRATE_SERVER);
        }
        GlobalOrPluginPermission perm = this.parse(id);
        if (this.permissionBackend.user(target).test(perm)) {
            return new AccountResource.Capability(target, perm.permissionName());
        }
        throw new ResourceNotFoundException(id);
    }

    private GlobalOrPluginPermission parse(IdString id) throws ResourceNotFoundException {
        String name = id.get();
        GlobalPermission perm = GlobalPermission.byName(name);
        if (perm != null) {
            return perm;
        }
        int dash = name.lastIndexOf(45);
        if (dash < 0) {
            throw new ResourceNotFoundException(id);
        }
        String pluginName = name.substring(0, dash);
        String capability = name.substring(dash + 1);
        if (pluginName.isEmpty() || capability.isEmpty()) {
            throw new ResourceNotFoundException(id);
        }
        return new PluginPermission(pluginName, capability);
    }

    @Override
    public DynamicMap<RestView<AccountResource.Capability>> views() {
        return this.views;
    }
}

