/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GlobalCapability;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.server.config.AdministrateServerGroups;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CapabilityCollection {
    private final SystemGroupBackend systemGroupBackend;
    private final ImmutableMap<String, ImmutableList<PermissionRule>> permissions;
    public final ImmutableList<PermissionRule> administrateServer;
    public final ImmutableList<PermissionRule> batchChangesLimit;
    public final ImmutableList<PermissionRule> emailReviewers;
    public final ImmutableList<PermissionRule> priority;
    public final ImmutableList<PermissionRule> queryLimit;

    @Inject
    CapabilityCollection(SystemGroupBackend systemGroupBackend, @AdministrateServerGroups ImmutableSet<GroupReference> admins, @Assisted @Nullable AccessSection section) {
        this.systemGroupBackend = systemGroupBackend;
        if (section == null) {
            section = new AccessSection("GLOBAL_CAPABILITIES");
        }
        HashMap<String, List<PermissionRule>> tmp = new HashMap<String, List<PermissionRule>>();
        for (Permission permission : section.getPermissions()) {
            for (PermissionRule rule : permission.getRules()) {
                if (!permission.getName().equals("emailReviewers") && rule.getAction() == PermissionRule.Action.DENY) continue;
                ArrayList<PermissionRule> r = (ArrayList<PermissionRule>)tmp.get(permission.getName());
                if (r == null) {
                    r = new ArrayList<PermissionRule>(2);
                    tmp.put(permission.getName(), r);
                }
                r.add(rule);
            }
        }
        this.configureDefaults(tmp, section);
        if (!tmp.containsKey("administrateServer") && !admins.isEmpty()) {
            tmp.put("administrateServer", ImmutableList.of());
        }
        ImmutableMap.Builder<String, ImmutableList<PermissionRule>> m = ImmutableMap.builder();
        for (Map.Entry e : tmp.entrySet()) {
            List<PermissionRule> rules = (List<PermissionRule>)e.getValue();
            if ("administrateServer".equals(e.getKey())) {
                rules = CapabilityCollection.mergeAdmin(admins, rules);
            }
            m.put((String)e.getKey(), ImmutableList.copyOf(rules));
        }
        this.permissions = m.build();
        this.administrateServer = this.getPermission("administrateServer");
        this.batchChangesLimit = this.getPermission("batchChangesLimit");
        this.emailReviewers = this.getPermission("emailReviewers");
        this.priority = this.getPermission("priority");
        this.queryLimit = this.getPermission("queryLimit");
    }

    private static List<PermissionRule> mergeAdmin(Set<GroupReference> admins, List<PermissionRule> rules) {
        if (admins.isEmpty()) {
            return rules;
        }
        ArrayList<PermissionRule> r = new ArrayList<PermissionRule>(admins.size() + rules.size());
        for (GroupReference g : admins) {
            r.add(new PermissionRule(g));
        }
        for (PermissionRule rule : rules) {
            if (admins.contains(rule.getGroup())) continue;
            r.add(rule);
        }
        return r;
    }

    public ImmutableList<PermissionRule> getPermission(String permissionName) {
        ImmutableList<PermissionRule> r = this.permissions.get(permissionName);
        return r != null ? r : ImmutableList.of();
    }

    private void configureDefaults(Map<String, List<PermissionRule>> out, AccessSection section) {
        CapabilityCollection.configureDefault(out, section, "queryLimit", this.systemGroupBackend.getGroup(SystemGroupBackend.ANONYMOUS_USERS));
    }

    private static void configureDefault(Map<String, List<PermissionRule>> out, AccessSection section, String capName, GroupReference group) {
        PermissionRange.WithDefaults range;
        if (CapabilityCollection.doesNotDeclare(section, capName) && (range = GlobalCapability.getRange(capName)) != null) {
            PermissionRule rule = new PermissionRule(group);
            rule.setRange(range.getDefaultMin(), range.getDefaultMax());
            out.put(capName, Collections.singletonList(rule));
        }
    }

    private static boolean doesNotDeclare(AccessSection section, String capName) {
        return section.getPermission(capName) == null;
    }

    public static interface Factory {
        public CapabilityCollection create(@Nullable AccessSection var1);
    }
}

