/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.StartupCheck;
import com.google.gerrit.server.StartupException;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupBackends;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UniversalGroupBackend
implements GroupBackend {
    private static final Logger log = LoggerFactory.getLogger(UniversalGroupBackend.class);
    private final DynamicSet<GroupBackend> backends;

    @Inject
    UniversalGroupBackend(DynamicSet<GroupBackend> backends) {
        this.backends = backends;
    }

    @Nullable
    private GroupBackend backend(AccountGroup.UUID uuid) {
        if (uuid != null) {
            for (GroupBackend g : this.backends) {
                if (!g.handles(uuid)) continue;
                return g;
            }
        }
        return null;
    }

    @Override
    public boolean handles(AccountGroup.UUID uuid) {
        return this.backend(uuid) != null;
    }

    @Override
    public GroupDescription.Basic get(AccountGroup.UUID uuid) {
        if (uuid == null) {
            return null;
        }
        GroupBackend b = this.backend(uuid);
        if (b == null) {
            log.debug("Unknown GroupBackend for UUID: " + uuid);
            return null;
        }
        return b.get(uuid);
    }

    @Override
    public Collection<GroupReference> suggest(String name, ProjectState project) {
        TreeSet<GroupReference> groups = Sets.newTreeSet(GroupBackends.GROUP_REF_NAME_COMPARATOR);
        for (GroupBackend g : this.backends) {
            groups.addAll(g.suggest(name, project));
        }
        return groups;
    }

    @Override
    public GroupMembership membershipsOf(IdentifiedUser user) {
        return new UniversalGroupMembership(user);
    }

    @Override
    public boolean isVisibleToAll(AccountGroup.UUID uuid) {
        for (GroupBackend g : this.backends) {
            if (!g.handles(uuid)) continue;
            return g.isVisibleToAll(uuid);
        }
        return false;
    }

    public static class ConfigCheck
    implements StartupCheck {
        private final Config cfg;
        private final UniversalGroupBackend universalGroupBackend;

        @Inject
        ConfigCheck(@GerritServerConfig Config cfg, UniversalGroupBackend groupBackend) {
            this.cfg = cfg;
            this.universalGroupBackend = groupBackend;
        }

        @Override
        public void check() throws StartupException {
            String invalid = this.cfg.getSubsections("groups").stream().filter(sub -> {
                AccountGroup.UUID uuid = new AccountGroup.UUID((String)sub);
                GroupBackend groupBackend = this.universalGroupBackend.backend(uuid);
                return groupBackend == null || groupBackend.get(uuid) == null;
            }).map(u -> "'" + u + "'").collect(Collectors.joining(","));
            if (!invalid.isEmpty()) {
                throw new StartupException(String.format("Subsections for 'groups' in gerrit.config must be valid group UUIDs. The following group UUIDs could not be resolved: " + invalid + " Please remove/fix these 'groups' subsections in gerrit.config.", new Object[0]));
            }
        }
    }

    private class UniversalGroupMembership
    implements GroupMembership {
        private final Map<GroupBackend, GroupMembership> memberships;

        private UniversalGroupMembership(IdentifiedUser user) {
            ImmutableMap.Builder<GroupBackend, GroupMembership> builder = ImmutableMap.builder();
            for (GroupBackend g : UniversalGroupBackend.this.backends) {
                builder.put(g, g.membershipsOf(user));
            }
            this.memberships = builder.build();
        }

        @Nullable
        private GroupMembership membership(AccountGroup.UUID uuid) {
            if (uuid != null) {
                for (Map.Entry<GroupBackend, GroupMembership> m : this.memberships.entrySet()) {
                    if (!m.getKey().handles(uuid)) continue;
                    return m.getValue();
                }
            }
            return null;
        }

        @Override
        public boolean contains(AccountGroup.UUID uuid) {
            if (uuid == null) {
                return false;
            }
            GroupMembership m = this.membership(uuid);
            if (m == null) {
                log.debug("Unknown GroupMembership for UUID: " + uuid);
                return false;
            }
            return m.contains(uuid);
        }

        @Override
        public boolean containsAnyOf(Iterable<AccountGroup.UUID> uuids) {
            GroupMembership m;
            Multimap lookups = MultimapBuilder.hashKeys().arrayListValues().build();
            for (AccountGroup.UUID uUID : uuids) {
                if (uUID == null) continue;
                m = this.membership(uUID);
                if (m == null) {
                    log.debug("Unknown GroupMembership for UUID: " + uUID);
                    continue;
                }
                lookups.put(m, uUID);
            }
            for (Map.Entry entry : lookups.asMap().entrySet()) {
                m = (GroupMembership)entry.getKey();
                Collection ids = (Collection)entry.getValue();
                if (!(ids.size() == 1 ? m.contains((AccountGroup.UUID)Iterables.getOnlyElement(ids)) : m.containsAnyOf(ids))) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<AccountGroup.UUID> intersection(Iterable<AccountGroup.UUID> uuids) {
            Multimap lookups = MultimapBuilder.hashKeys().arrayListValues().build();
            for (AccountGroup.UUID uuid : uuids) {
                if (uuid == null) continue;
                GroupMembership m = this.membership(uuid);
                if (m == null) {
                    log.debug("Unknown GroupMembership for UUID: " + uuid);
                    continue;
                }
                lookups.put(m, uuid);
            }
            HashSet<AccountGroup.UUID> groups = new HashSet<AccountGroup.UUID>();
            for (Map.Entry entry : lookups.asMap().entrySet()) {
                groups.addAll(((GroupMembership)entry.getKey()).intersection(entry.getValue()));
            }
            return groups;
        }

        @Override
        public Set<AccountGroup.UUID> getKnownGroups() {
            HashSet<AccountGroup.UUID> groups = new HashSet<AccountGroup.UUID>();
            for (GroupMembership m : this.memberships.values()) {
                groups.addAll(m.getKnownGroups());
            }
            return groups;
        }
    }
}

