/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import com.google.gerrit.common.errors.InvalidSshKeyException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AuthorizedKeys;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.VersionedMetaData;
import com.google.gerrit.server.ssh.SshKeyCreator;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Repository;

public class VersionedAuthorizedKeys
extends VersionedMetaData {
    private final SshKeyCreator sshKeyCreator;
    private final Account.Id accountId;
    private final String ref;
    private List<Optional<AccountSshKey>> keys;

    @Inject
    public VersionedAuthorizedKeys(SshKeyCreator sshKeyCreator, @Assisted Account.Id accountId) {
        this.sshKeyCreator = sshKeyCreator;
        this.accountId = accountId;
        this.ref = RefNames.refsUsers(accountId);
    }

    @Override
    protected String getRefName() {
        return this.ref;
    }

    @Override
    protected void onLoad() throws IOException {
        this.keys = AuthorizedKeys.parse(this.accountId, this.readUTF8("authorized_keys"));
    }

    @Override
    protected boolean onSave(CommitBuilder commit) throws IOException {
        if (Strings.isNullOrEmpty(commit.getMessage())) {
            commit.setMessage("Updated SSH keys\n");
        }
        this.saveUTF8("authorized_keys", AuthorizedKeys.serialize(this.keys));
        return true;
    }

    private List<AccountSshKey> getKeys() {
        this.checkLoaded();
        return this.keys.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private AccountSshKey getKey(int seq) {
        this.checkLoaded();
        return this.keys.get(seq - 1).orElse(null);
    }

    private AccountSshKey addKey(String pub) throws InvalidSshKeyException {
        this.checkLoaded();
        for (Optional<AccountSshKey> key : this.keys) {
            if (!key.isPresent() || !key.get().getSshPublicKey().trim().equals(pub.trim())) continue;
            return key.get();
        }
        int seq = this.keys.size() + 1;
        AccountSshKey.Id keyId = new AccountSshKey.Id(this.accountId, seq);
        AccountSshKey key = this.sshKeyCreator.create(keyId, pub);
        this.keys.add(Optional.of(key));
        return key;
    }

    private boolean deleteKey(int seq) {
        this.checkLoaded();
        if (seq <= this.keys.size() && this.keys.get(seq - 1).isPresent()) {
            this.keys.set(seq - 1, Optional.empty());
            return true;
        }
        return false;
    }

    private boolean markKeyInvalid(int seq) {
        this.checkLoaded();
        AccountSshKey key = this.getKey(seq);
        if (key != null && key.isValid()) {
            key.setInvalid();
            return true;
        }
        return false;
    }

    public void setKeys(Collection<AccountSshKey> newKeys) {
        Ordering<AccountSshKey> o = Ordering.from(Comparator.comparing(k -> k.getKey().get()));
        this.keys = new ArrayList(Collections.nCopies(o.max(newKeys).getKey().get(), Optional.empty()));
        for (AccountSshKey key : newKeys) {
            this.keys.set(key.getKey().get() - 1, Optional.of(key));
        }
    }

    private void checkLoaded() {
        Preconditions.checkState(this.keys != null, "SSH keys not loaded yet");
    }

    public static interface Factory {
        public VersionedAuthorizedKeys create(Account.Id var1);
    }

    public static class SimpleSshKeyCreator
    implements SshKeyCreator {
        @Override
        public AccountSshKey create(AccountSshKey.Id id, String encoded) {
            return new AccountSshKey(id, encoded);
        }
    }

    @Singleton
    public static class Accessor {
        private final GitRepositoryManager repoManager;
        private final AllUsersName allUsersName;
        private final Factory authorizedKeysFactory;
        private final Provider<MetaDataUpdate.User> metaDataUpdateFactory;
        private final IdentifiedUser.GenericFactory userFactory;

        @Inject
        Accessor(GitRepositoryManager repoManager, AllUsersName allUsersName, Factory authorizedKeysFactory, Provider<MetaDataUpdate.User> metaDataUpdateFactory, IdentifiedUser.GenericFactory userFactory) {
            this.repoManager = repoManager;
            this.allUsersName = allUsersName;
            this.authorizedKeysFactory = authorizedKeysFactory;
            this.metaDataUpdateFactory = metaDataUpdateFactory;
            this.userFactory = userFactory;
        }

        public List<AccountSshKey> getKeys(Account.Id accountId) throws IOException, ConfigInvalidException {
            return this.read(accountId).getKeys();
        }

        public AccountSshKey getKey(Account.Id accountId, int seq) throws IOException, ConfigInvalidException {
            return this.read(accountId).getKey(seq);
        }

        public synchronized AccountSshKey addKey(Account.Id accountId, String pub) throws IOException, ConfigInvalidException, InvalidSshKeyException {
            VersionedAuthorizedKeys authorizedKeys = this.read(accountId);
            AccountSshKey key = authorizedKeys.addKey(pub);
            this.commit(authorizedKeys);
            return key;
        }

        public synchronized void deleteKey(Account.Id accountId, int seq) throws IOException, ConfigInvalidException {
            VersionedAuthorizedKeys authorizedKeys = this.read(accountId);
            if (authorizedKeys.deleteKey(seq)) {
                this.commit(authorizedKeys);
            }
        }

        public synchronized void markKeyInvalid(Account.Id accountId, int seq) throws IOException, ConfigInvalidException {
            VersionedAuthorizedKeys authorizedKeys = this.read(accountId);
            if (authorizedKeys.markKeyInvalid(seq)) {
                this.commit(authorizedKeys);
            }
        }

        private VersionedAuthorizedKeys read(Account.Id accountId) throws IOException, ConfigInvalidException {
            try (Repository git = this.repoManager.openRepository(this.allUsersName);){
                VersionedAuthorizedKeys authorizedKeys = this.authorizedKeysFactory.create(accountId);
                authorizedKeys.load(git);
                VersionedAuthorizedKeys versionedAuthorizedKeys = authorizedKeys;
                return versionedAuthorizedKeys;
            }
        }

        private void commit(VersionedAuthorizedKeys authorizedKeys) throws IOException {
            try (MetaDataUpdate md = this.metaDataUpdateFactory.get().create(this.allUsersName, this.userFactory.create(authorizedKeys.accountId));){
                authorizedKeys.commit(md);
            }
        }
    }
}

