/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.accounts;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.google.gerrit.extensions.common.AccountInfo;
import java.util.Comparator;

public class AccountInfoComparator
extends Ordering<AccountInfo>
implements Comparator<AccountInfo> {
    public static final AccountInfoComparator ORDER_NULLS_FIRST = new AccountInfoComparator();
    public static final AccountInfoComparator ORDER_NULLS_LAST = new AccountInfoComparator().setNullsLast();
    private boolean nullsLast;

    private AccountInfoComparator() {
    }

    private AccountInfoComparator setNullsLast() {
        this.nullsLast = true;
        return this;
    }

    @Override
    public int compare(AccountInfo a, AccountInfo b) {
        return ComparisonChain.start().compare(a.name, b.name, this.createOrdering()).compare(a.email, b.email, this.createOrdering()).compare(a._accountId, b._accountId, this.createOrdering()).result();
    }

    private <S extends Comparable<?>> Ordering<S> createOrdering() {
        if (this.nullsLast) {
            return Ordering.natural().nullsLast();
        }
        return Ordering.natural().nullsFirst();
    }
}

