/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.plugins;

import com.google.gerrit.extensions.api.plugins.PluginApi;
import com.google.gerrit.extensions.api.plugins.Plugins;
import com.google.gerrit.extensions.common.InstallPluginInput;
import com.google.gerrit.extensions.common.PluginInfo;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.api.plugins.PluginApiImpl;
import com.google.gerrit.server.plugins.InstallPlugin;
import com.google.gerrit.server.plugins.ListPlugins;
import com.google.gerrit.server.plugins.PluginsCollection;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.SortedMap;

@Singleton
public class PluginsImpl
implements Plugins {
    private final PluginsCollection plugins;
    private final Provider<ListPlugins> listProvider;
    private final Provider<InstallPlugin> installProvider;
    private final PluginApiImpl.Factory pluginApi;

    @Inject
    PluginsImpl(PluginsCollection plugins, Provider<ListPlugins> listProvider, Provider<InstallPlugin> installProvider, PluginApiImpl.Factory pluginApi) {
        this.plugins = plugins;
        this.listProvider = listProvider;
        this.installProvider = installProvider;
        this.pluginApi = pluginApi;
    }

    @Override
    public PluginApi name(String name) throws RestApiException {
        return this.pluginApi.create(this.plugins.parse(name));
    }

    @Override
    public Plugins.ListRequest list() {
        return new Plugins.ListRequest(){

            @Override
            public SortedMap<String, PluginInfo> getAsMap() throws RestApiException {
                return ((ListPlugins)PluginsImpl.this.listProvider.get()).request(this).apply(TopLevelResource.INSTANCE);
            }
        };
    }

    @Override
    public PluginApi install(String name, InstallPluginInput input) throws RestApiException {
        try {
            Response<PluginInfo> created = this.installProvider.get().setName(name).apply(TopLevelResource.INSTANCE, input);
            return this.pluginApi.create(this.plugins.parse(created.value().id));
        }
        catch (IOException e) {
            throw new RestApiException("could not install plugin", e);
        }
    }
}

