/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth.openid;

import com.google.gerrit.server.account.externalids.ExternalId;

public class OpenIdProviderPattern {
    protected boolean regex;
    protected String pattern;

    public static OpenIdProviderPattern create(String pattern) {
        OpenIdProviderPattern r = new OpenIdProviderPattern();
        r.regex = pattern.startsWith("^") && pattern.endsWith("$");
        r.pattern = pattern;
        return r;
    }

    protected OpenIdProviderPattern() {
    }

    public boolean matches(String id) {
        return this.regex ? id.matches(this.pattern) : id.startsWith(this.pattern);
    }

    public boolean matches(ExternalId extId) {
        return this.matches(extId.key().get());
    }

    public String toString() {
        return this.pattern;
    }
}

