/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.cache.h2;

import com.google.common.base.Throwables;
import com.google.common.cache.AbstractLoadingCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.google.common.hash.PrimitiveSink;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.server.cache.PersistentCache;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.h2.Driver;
import org.h2.jdbc.JdbcSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2CacheImpl<K, V>
extends AbstractLoadingCache<K, V>
implements PersistentCache {
    private static final Logger log = LoggerFactory.getLogger(H2CacheImpl.class);
    private static final ImmutableSet<String> OLD_CLASS_NAMES = ImmutableSet.of("com.google.gerrit.server.change.ChangeKind");
    private final Executor executor;
    private final SqlStore<K, V> store;
    private final TypeLiteral<K> keyType;
    private final Cache<K, ValueHolder<V>> mem;

    H2CacheImpl(Executor executor, SqlStore<K, V> store, TypeLiteral<K> keyType, Cache<K, ValueHolder<V>> mem) {
        this.executor = executor;
        this.store = store;
        this.keyType = keyType;
        this.mem = mem;
    }

    @Override
    public V getIfPresent(Object objKey) {
        if (!this.keyType.getRawType().isInstance(objKey)) {
            return null;
        }
        Object key = objKey;
        ValueHolder<V> h = this.mem.getIfPresent(key);
        if (h != null) {
            return h.value;
        }
        if (this.store.mightContain(key) && (h = this.store.getIfPresent(key)) != null) {
            this.mem.put(key, h);
            return h.value;
        }
        return null;
    }

    @Override
    public V get(K key) throws ExecutionException {
        if (this.mem instanceof LoadingCache) {
            return ((ValueHolder)((LoadingCache)this.mem).get(key)).value;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        return this.mem.get(key, (Callable<ValueHolder>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$get$1(java.lang.Object java.util.concurrent.Callable ), ()Lcom/google/gerrit/server/cache/h2/H2CacheImpl$ValueHolder;)((H2CacheImpl)this, key, valueLoader)).value;
    }

    @Override
    public void put(K key, V val) {
        ValueHolder<V> h = new ValueHolder<V>(val);
        h.created = TimeUtil.nowMs();
        this.mem.put(key, h);
        this.executor.execute(() -> this.store.put(key, h));
    }

    @Override
    public void invalidate(Object key) {
        if (this.keyType.getRawType().isInstance(key) && this.store.mightContain(key)) {
            this.executor.execute(() -> this.store.invalidate(key));
        }
        this.mem.invalidate(key);
    }

    @Override
    public void invalidateAll() {
        this.store.invalidateAll();
        this.mem.invalidateAll();
    }

    @Override
    public long size() {
        return this.mem.size();
    }

    @Override
    public CacheStats stats() {
        return this.mem.stats();
    }

    @Override
    public PersistentCache.DiskStats diskStats() {
        return this.store.diskStats();
    }

    void start() {
        this.store.open();
    }

    void stop() {
        for (Map.Entry e : this.mem.asMap().entrySet()) {
            ValueHolder h = (ValueHolder)e.getValue();
            if (h.clean) continue;
            this.store.put(e.getKey(), h);
        }
        this.store.close();
    }

    void prune(ScheduledExecutorService service) {
        this.store.prune(this.mem);
        Calendar cal = Calendar.getInstance();
        cal.set(11, 1);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, 1);
        long delay = cal.getTimeInMillis() - TimeUtil.nowMs();
        ScheduledFuture<?> possiblyIgnoredError = service.schedule(() -> this.prune(service), delay, TimeUnit.MILLISECONDS);
    }

    private /* synthetic */ ValueHolder lambda$get$1(Object key, Callable valueLoader) throws Exception {
        ValueHolder<V> h;
        if (this.store.mightContain(key) && (h = this.store.getIfPresent(key)) != null) {
            return h;
        }
        h = new ValueHolder(valueLoader.call());
        h.created = TimeUtil.nowMs();
        this.executor.execute(() -> this.store.put(key, h));
        return h;
    }

    private static class SinkOutputStream
    extends OutputStream {
        private final PrimitiveSink sink;

        SinkOutputStream(PrimitiveSink sink) {
            this.sink = sink;
        }

        @Override
        public void write(int b) {
            this.sink.putByte((byte)b);
        }

        @Override
        public void write(byte[] b, int p, int n) {
            this.sink.putBytes(b, p, n);
        }
    }

    static class SqlHandle {
        private final String url;
        Connection conn;
        PreparedStatement get;
        PreparedStatement put;
        PreparedStatement touch;
        PreparedStatement invalidate;

        SqlHandle(String url, KeyType<?> type) throws SQLException {
            this.url = url;
            this.conn = Driver.load().connect(url, null);
            try (Statement stmt = this.conn.createStatement();){
                stmt.addBatch("CREATE TABLE IF NOT EXISTS data(k " + type.columnType() + " NOT NULL PRIMARY KEY HASH,v OTHER NOT NULL,created TIMESTAMP NOT NULL,accessed TIMESTAMP NOT NULL)");
                stmt.addBatch("ALTER TABLE data ADD COLUMN IF NOT EXISTS space BIGINT AS OCTET_LENGTH(k) + OCTET_LENGTH(v)");
                stmt.executeBatch();
            }
        }

        void close() {
            this.get = this.closeStatement(this.get);
            this.put = this.closeStatement(this.put);
            this.touch = this.closeStatement(this.touch);
            this.invalidate = this.closeStatement(this.invalidate);
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    log.warn("Cannot close connection to " + this.url, e);
                }
                finally {
                    this.conn = null;
                }
            }
        }

        private PreparedStatement closeStatement(PreparedStatement ps) {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.warn("Cannot close statement for " + this.url, e);
                }
            }
            return null;
        }
    }

    static class SqlStore<K, V> {
        private final String url;
        private final KeyType<K> keyType;
        private final long maxSize;
        private final long expireAfterWrite;
        private final BlockingQueue<SqlHandle> handles;
        private final AtomicLong hitCount = new AtomicLong();
        private final AtomicLong missCount = new AtomicLong();
        private volatile BloomFilter<K> bloomFilter;
        private int estimatedSize;

        SqlStore(String jdbcUrl, TypeLiteral<K> keyType, long maxSize, long expireAfterWrite) {
            this.url = jdbcUrl;
            this.keyType = KeyType.create(keyType);
            this.maxSize = maxSize;
            this.expireAfterWrite = expireAfterWrite;
            int cores = Runtime.getRuntime().availableProcessors();
            int keep = Math.min(cores, 16);
            this.handles = new ArrayBlockingQueue<SqlHandle>(keep);
        }

        synchronized void open() {
            if (this.bloomFilter == null) {
                this.bloomFilter = this.buildBloomFilter();
            }
        }

        void close() {
            SqlHandle h;
            while ((h = (SqlHandle)this.handles.poll()) != null) {
                h.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean mightContain(K key) {
            BloomFilter<K> b = this.bloomFilter;
            if (b == null) {
                SqlStore sqlStore = this;
                synchronized (sqlStore) {
                    b = this.bloomFilter;
                    if (b == null) {
                        b = this.buildBloomFilter();
                        this.bloomFilter = b;
                    }
                }
            }
            return b == null || b.mightContain(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BloomFilter<K> buildBloomFilter() {
            SqlHandle c = null;
            try {
                BloomFilter<K> bloomFilter;
                block30: {
                    c = this.acquire();
                    Statement s = c.conn.createStatement();
                    try {
                        if (this.estimatedSize <= 0) {
                            try (ResultSet r = s.executeQuery("SELECT COUNT(*) FROM data");){
                                this.estimatedSize = r.next() ? r.getInt(1) : 0;
                            }
                        }
                        BloomFilter<K> b = this.newBloomFilter();
                        try (ResultSet r = s.executeQuery("SELECT k FROM data");){
                            while (r.next()) {
                                b.put(this.keyType.get(r, 1));
                            }
                        }
                        catch (JdbcSQLException e) {
                            if (e.getCause() instanceof InvalidClassException) {
                                log.warn("Entries cached for " + this.url + " have an incompatible class and can't be deserialized. Cache is flushed.");
                                this.invalidateAll();
                            }
                            throw e;
                        }
                        bloomFilter = b;
                        if (s == null) break block30;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (s != null) {
                                try {
                                    s.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            log.warn("Cannot build BloomFilter for " + this.url + ": " + e.getMessage());
                            c = this.close(c);
                            BloomFilter<K> bloomFilter2 = null;
                            return bloomFilter2;
                        }
                    }
                    s.close();
                }
                return bloomFilter;
            }
            finally {
                this.release(c);
            }
        }

        /*
         * Exception decompiling
         */
        ValueHolder<V> getIfPresent(K key) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static boolean isOldClassNameError(Throwable t) {
            for (Throwable c : Throwables.getCausalChain(t)) {
                if (!(c instanceof ClassNotFoundException) || !OLD_CLASS_NAMES.contains(c.getMessage())) continue;
                return true;
            }
            return false;
        }

        private boolean expired(Timestamp created) {
            if (this.expireAfterWrite == 0L) {
                return false;
            }
            long age = TimeUtil.nowMs() - created.getTime();
            return 1000L * this.expireAfterWrite < age;
        }

        private void touch(SqlHandle c, K key) throws SQLException {
            if (c.touch == null) {
                c.touch = c.conn.prepareStatement("UPDATE data SET accessed=? WHERE k=?");
            }
            try {
                c.touch.setTimestamp(1, TimeUtil.nowTs());
                this.keyType.set(c.touch, 2, key);
                c.touch.executeUpdate();
            }
            finally {
                c.touch.clearParameters();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(K key, ValueHolder<V> holder) {
            if (holder.clean) {
                return;
            }
            BloomFilter<K> b = this.bloomFilter;
            if (b != null) {
                b.put(key);
                this.bloomFilter = b;
            }
            SqlHandle c = null;
            try {
                c = this.acquire();
                if (c.put == null) {
                    c.put = c.conn.prepareStatement("MERGE INTO data (k, v, created, accessed) VALUES(?,?,?,?)");
                }
                try {
                    this.keyType.set(c.put, 1, key);
                    c.put.setObject(2, holder.value, 2000);
                    c.put.setTimestamp(3, new Timestamp(holder.created));
                    c.put.setTimestamp(4, TimeUtil.nowTs());
                    c.put.executeUpdate();
                    holder.clean = true;
                }
                finally {
                    c.put.clearParameters();
                }
            }
            catch (SQLException e) {
                log.warn("Cannot put into cache " + this.url, e);
                c = this.close(c);
            }
            finally {
                this.release(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void invalidate(K key) {
            SqlHandle c = null;
            try {
                c = this.acquire();
                this.invalidate(c, key);
            }
            catch (SQLException e) {
                log.warn("Cannot invalidate cache " + this.url, e);
                c = this.close(c);
            }
            finally {
                this.release(c);
            }
        }

        private void invalidate(SqlHandle c, K key) throws SQLException {
            if (c.invalidate == null) {
                c.invalidate = c.conn.prepareStatement("DELETE FROM data WHERE k=?");
            }
            try {
                this.keyType.set(c.invalidate, 1, key);
                c.invalidate.executeUpdate();
            }
            finally {
                c.invalidate.clearParameters();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void invalidateAll() {
            SqlHandle c = null;
            try {
                c = this.acquire();
                try (Statement s = c.conn.createStatement();){
                    s.executeUpdate("DELETE FROM data");
                }
                this.bloomFilter = this.newBloomFilter();
            }
            catch (SQLException e) {
                log.warn("Cannot invalidate cache " + this.url, e);
                c = this.close(c);
            }
            finally {
                this.release(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void prune(Cache<K, ?> mem) {
            SqlHandle c = null;
            try {
                c = this.acquire();
                try (Statement s = c.conn.createStatement();){
                    long used = 0L;
                    try (ResultSet r = s.executeQuery("SELECT SUM(space) FROM data");){
                        used = r.next() ? r.getLong(1) : 0L;
                    }
                    if (used <= this.maxSize) {
                        return;
                    }
                    r = s.executeQuery("SELECT k,space,created FROM data ORDER BY accessed");
                    try {
                        while (this.maxSize < used && r.next()) {
                            K key = this.keyType.get(r, 1);
                            Timestamp created = r.getTimestamp(3);
                            if (mem.getIfPresent(key) != null && !this.expired(created)) {
                                this.touch(c, key);
                                continue;
                            }
                            this.invalidate(c, key);
                            used -= r.getLong(2);
                        }
                    }
                    finally {
                        if (r != null) {
                            r.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                log.warn("Cannot prune cache " + this.url, e);
                c = this.close(c);
            }
            finally {
                this.release(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PersistentCache.DiskStats diskStats() {
            long size = 0L;
            long space = 0L;
            SqlHandle c = null;
            try {
                c = this.acquire();
                try (Statement s = c.conn.createStatement();
                     ResultSet r = s.executeQuery("SELECT COUNT(*),SUM(space) FROM data");){
                    if (r.next()) {
                        size = r.getLong(1);
                        space = r.getLong(2);
                    }
                }
            }
            catch (SQLException e) {
                log.warn("Cannot get DiskStats for " + this.url, e);
                c = this.close(c);
            }
            finally {
                this.release(c);
            }
            return new PersistentCache.DiskStats(size, space, this.hitCount.get(), this.missCount.get());
        }

        private SqlHandle acquire() throws SQLException {
            SqlHandle h = (SqlHandle)this.handles.poll();
            return h != null ? h : new SqlHandle(this.url, this.keyType);
        }

        private void release(SqlHandle h) {
            if (h != null && !this.handles.offer(h)) {
                h.close();
            }
        }

        private SqlHandle close(SqlHandle h) {
            if (h != null) {
                h.close();
            }
            return null;
        }

        private BloomFilter<K> newBloomFilter() {
            int cnt = Math.max(65536, 2 * this.estimatedSize);
            return BloomFilter.create(this.keyType.funnel(), cnt);
        }
    }

    private static class KeyType<K> {
        static final KeyType<?> OTHER = new KeyType();
        static final KeyType<String> STRING = new KeyType<String>(){

            @Override
            String columnType() {
                return "VARCHAR(4096)";
            }

            @Override
            String get(ResultSet rs, int col) throws SQLException {
                return rs.getString(col);
            }

            @Override
            void set(PreparedStatement ps, int col, String value) throws SQLException {
                ps.setString(col, value);
            }

            @Override
            Funnel<String> funnel() {
                Funnel<CharSequence> s = Funnels.unencodedCharsFunnel();
                return s;
            }
        };

        private KeyType() {
        }

        String columnType() {
            return "OTHER";
        }

        K get(ResultSet rs, int col) throws SQLException {
            return (K)rs.getObject(col);
        }

        void set(PreparedStatement ps, int col, K value) throws SQLException {
            ps.setObject(col, value, 2000);
        }

        Funnel<K> funnel() {
            return new Funnel<K>(){
                private static final long serialVersionUID = 1L;

                @Override
                public void funnel(K from, PrimitiveSink into) {
                    try (ObjectOutputStream ser = new ObjectOutputStream(new SinkOutputStream(into));){
                        ser.writeObject(from);
                        ser.flush();
                    }
                    catch (IOException err) {
                        throw new RuntimeException("Cannot hash as Serializable", err);
                    }
                }
            };
        }

        static <K> KeyType<K> create(TypeLiteral<K> type) {
            if (type.getRawType() == String.class) {
                return STRING;
            }
            return OTHER;
        }
    }

    static class Loader<K, V>
    extends CacheLoader<K, ValueHolder<V>> {
        private final Executor executor;
        private final SqlStore<K, V> store;
        private final CacheLoader<K, V> loader;

        Loader(Executor executor, SqlStore<K, V> store, CacheLoader<K, V> loader) {
            this.executor = executor;
            this.store = store;
            this.loader = loader;
        }

        @Override
        public ValueHolder<V> load(K key) throws Exception {
            ValueHolder<V> h;
            if (this.store.mightContain(key) && (h = this.store.getIfPresent(key)) != null) {
                return h;
            }
            h = new ValueHolder<V>(this.loader.load(key));
            h.created = TimeUtil.nowMs();
            this.executor.execute(() -> this.store.put(key, h));
            return h;
        }
    }

    static class ValueHolder<V> {
        final V value;
        long created;
        volatile boolean clean;

        ValueHolder(V value) {
            this.value = value;
        }
    }
}

