/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.edit.ChangeEdit;
import com.google.gerrit.server.edit.ChangeEditUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Optional;

@Singleton
public class DeleteChangeEdit
implements RestModifyView<ChangeResource, Input> {
    private final ChangeEditUtil editUtil;

    @Inject
    DeleteChangeEdit(ChangeEditUtil editUtil) {
        this.editUtil = editUtil;
    }

    public Response<?> apply(ChangeResource rsrc, Input input) throws AuthException, ResourceNotFoundException, IOException, OrmException {
        Optional<ChangeEdit> edit = this.editUtil.byChange(rsrc.getNotes(), rsrc.getUser());
        if (!edit.isPresent()) {
            throw new ResourceNotFoundException();
        }
        this.editUtil.delete(edit.get());
        return Response.none();
    }

    public static class Input {
    }
}

