/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.RobotComment;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.change.ListRobotComments;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.RobotCommentResource;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class RobotComments
implements ChildCollection<RevisionResource, RobotCommentResource> {
    private final DynamicMap<RestView<RobotCommentResource>> views;
    private final ListRobotComments list;
    private final CommentsUtil commentsUtil;

    @Inject
    RobotComments(DynamicMap<RestView<RobotCommentResource>> views, ListRobotComments list, CommentsUtil commentsUtil) {
        this.views = views;
        this.list = list;
        this.commentsUtil = commentsUtil;
    }

    @Override
    public DynamicMap<RestView<RobotCommentResource>> views() {
        return this.views;
    }

    public ListRobotComments list() {
        return this.list;
    }

    @Override
    public RobotCommentResource parse(RevisionResource rev, IdString id) throws ResourceNotFoundException, OrmException {
        String uuid = id.get();
        ChangeNotes notes = rev.getNotes();
        for (RobotComment c : this.commentsUtil.robotCommentsByPatchSet(notes, rev.getPatchSet().getId())) {
            if (!uuid.equals(c.key.uuid)) continue;
            return new RobotCommentResource(rev, c);
        }
        throw new ResourceNotFoundException(id);
    }
}

