/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Preconditions;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.extensions.events.AssigneeChanged;
import com.google.gerrit.server.mail.send.SetAssigneeSender;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.validators.AssigneeValidationListener;
import com.google.gerrit.server.validators.ValidationException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetAssigneeOp
implements BatchUpdateOp {
    private static final Logger log = LoggerFactory.getLogger(SetAssigneeOp.class);
    private final ChangeMessagesUtil cmUtil;
    private final DynamicSet<AssigneeValidationListener> validationListeners;
    private final IdentifiedUser newAssignee;
    private final AssigneeChanged assigneeChanged;
    private final SetAssigneeSender.Factory setAssigneeSenderFactory;
    private final Provider<IdentifiedUser> user;
    private final IdentifiedUser.GenericFactory userFactory;
    private Change change;
    private IdentifiedUser oldAssignee;

    @Inject
    SetAssigneeOp(ChangeMessagesUtil cmUtil, DynamicSet<AssigneeValidationListener> validationListeners, AssigneeChanged assigneeChanged, SetAssigneeSender.Factory setAssigneeSenderFactory, Provider<IdentifiedUser> user, IdentifiedUser.GenericFactory userFactory, @Assisted IdentifiedUser newAssignee) {
        this.cmUtil = cmUtil;
        this.validationListeners = validationListeners;
        this.assigneeChanged = assigneeChanged;
        this.setAssigneeSenderFactory = setAssigneeSenderFactory;
        this.user = user;
        this.userFactory = userFactory;
        this.newAssignee = Preconditions.checkNotNull(newAssignee, "assignee");
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws OrmException, RestApiException {
        this.change = ctx.getChange();
        if (this.newAssignee.getAccountId().equals(this.change.getAssignee())) {
            return false;
        }
        try {
            for (AssigneeValidationListener validator : this.validationListeners) {
                validator.validateAssignee(this.change, this.newAssignee.getAccount());
            }
        }
        catch (ValidationException e) {
            throw new ResourceConflictException(e.getMessage());
        }
        if (this.change.getAssignee() != null) {
            this.oldAssignee = this.userFactory.create(this.change.getAssignee());
        }
        ChangeUpdate update = ctx.getUpdate(this.change.currentPatchSetId());
        update.setAssignee(this.newAssignee.getAccountId());
        this.change.setAssignee(this.newAssignee.getAccountId());
        this.addMessage(ctx, update);
        return true;
    }

    private void addMessage(ChangeContext ctx, ChangeUpdate update) throws OrmException {
        StringBuilder msg = new StringBuilder();
        msg.append("Assignee ");
        if (this.oldAssignee == null) {
            msg.append("added: ");
            msg.append(this.newAssignee.getNameEmail());
        } else {
            msg.append("changed from: ");
            msg.append(this.oldAssignee.getNameEmail());
            msg.append(" to: ");
            msg.append(this.newAssignee.getNameEmail());
        }
        ChangeMessage cmsg = ChangeMessagesUtil.newMessage(ctx, msg.toString(), "autogenerated:gerrit:setAssignee");
        this.cmUtil.addChangeMessage(ctx.getDb(), update, cmsg);
    }

    @Override
    public void postUpdate(Context ctx) throws OrmException {
        try {
            SetAssigneeSender cm = this.setAssigneeSenderFactory.create(this.change.getProject(), this.change.getId(), this.newAssignee.getAccountId());
            cm.setFrom(this.user.get().getAccountId());
            cm.send();
        }
        catch (Exception err) {
            log.error("Cannot send email to new assignee of change " + this.change.getId(), err);
        }
        this.assigneeChanged.fire(this.change, ctx.getAccount(), this.oldAssignee != null ? this.oldAssignee.getAccount() : null, ctx.getWhen());
    }

    public static interface Factory {
        public SetAssigneeOp create(IdentifiedUser var1);
    }
}

