/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.api.changes.SubmittedTogetherInfo;
import com.google.gerrit.extensions.api.changes.SubmittedTogetherOption;
import com.google.gerrit.extensions.client.ChangeStatus;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.WalkSorter;
import com.google.gerrit.server.git.ChangeSet;
import com.google.gerrit.server.git.MergeSuperSet;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmittedTogether
implements RestReadView<ChangeResource> {
    private static final Logger log = LoggerFactory.getLogger(SubmittedTogether.class);
    private final EnumSet<SubmittedTogetherOption> options = EnumSet.noneOf(SubmittedTogetherOption.class);
    private final EnumSet<ListChangesOption> jsonOpt = EnumSet.of(ListChangesOption.CURRENT_REVISION, ListChangesOption.CURRENT_COMMIT, ListChangesOption.SUBMITTABLE);
    private final ChangeJson.Factory json;
    private final Provider<ReviewDb> dbProvider;
    private final Provider<InternalChangeQuery> queryProvider;
    private final Provider<MergeSuperSet> mergeSuperSet;
    private final Provider<WalkSorter> sorter;

    @Option(name="-o", usage="Output options")
    void addOption(String option) {
        for (ListChangesOption listChangesOption : ListChangesOption.values()) {
            if (!listChangesOption.name().equalsIgnoreCase(option)) continue;
            this.jsonOpt.add(listChangesOption);
            return;
        }
        for (Enum enum_ : SubmittedTogetherOption.values()) {
            if (!enum_.name().equalsIgnoreCase(option)) continue;
            this.options.add((SubmittedTogetherOption)enum_);
            return;
        }
        throw new IllegalArgumentException("option not recognized: " + option);
    }

    @Inject
    SubmittedTogether(ChangeJson.Factory json, Provider<ReviewDb> dbProvider, Provider<InternalChangeQuery> queryProvider, Provider<MergeSuperSet> mergeSuperSet, Provider<WalkSorter> sorter) {
        this.json = json;
        this.dbProvider = dbProvider;
        this.queryProvider = queryProvider;
        this.mergeSuperSet = mergeSuperSet;
        this.sorter = sorter;
    }

    public SubmittedTogether addListChangesOption(EnumSet<ListChangesOption> o) {
        this.jsonOpt.addAll(o);
        return this;
    }

    public SubmittedTogether addSubmittedTogetherOption(EnumSet<SubmittedTogetherOption> o) {
        this.options.addAll(o);
        return this;
    }

    @Override
    public Object apply(ChangeResource resource) throws AuthException, BadRequestException, ResourceConflictException, IOException, OrmException, PermissionBackendException {
        SubmittedTogetherInfo info = this.applyInfo(resource);
        if (this.options.isEmpty()) {
            return info.changes;
        }
        return info;
    }

    public SubmittedTogetherInfo applyInfo(ChangeResource resource) throws AuthException, IOException, OrmException, PermissionBackendException {
        Change c = resource.getChange();
        try {
            int hidden;
            List<Object> cds;
            if (c.getStatus().isOpen()) {
                ChangeSet cs = this.mergeSuperSet.get().completeChangeSet(this.dbProvider.get(), c, resource.getUser());
                cds = cs.changes().asList();
                hidden = cs.nonVisibleChanges().size();
            } else if (c.getStatus().asChangeStatus() == ChangeStatus.MERGED) {
                cds = this.queryProvider.get().bySubmissionId(c.getSubmissionId());
                hidden = 0;
            } else {
                cds = Collections.emptyList();
                hidden = 0;
            }
            if (hidden != 0 && !this.options.contains((Object)SubmittedTogetherOption.NON_VISIBLE_CHANGES)) {
                throw new AuthException("change would be submitted with a change that you cannot see");
            }
            cds = cds.size() <= 1 && hidden == 0 ? Collections.emptyList() : this.sort(cds);
            SubmittedTogetherInfo info = new SubmittedTogetherInfo();
            info.changes = this.json.create(this.jsonOpt).formatChangeDatas(cds);
            info.nonVisibleChanges = hidden;
            return info;
        }
        catch (OrmException | IOException e) {
            log.error("Error on getting a ChangeSet", e);
            throw e;
        }
    }

    private List<ChangeData> sort(List<ChangeData> cds) throws OrmException, IOException {
        ArrayList<ChangeData> sorted = new ArrayList<ChangeData>(cds.size());
        for (WalkSorter.PatchSetData psd : this.sorter.get().sort(cds)) {
            sorted.add(psd.data());
        }
        return sorted;
    }
}

