/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.webui;

import com.google.common.base.Predicate;
import com.google.common.collect.Streams;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.access.GlobalOrPluginPermission;
import com.google.gerrit.extensions.conditions.BooleanCondition;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.RestCollection;
import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.webui.PrivateInternals_UiActionDescription;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendCondition;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UiActions {
    private static final Logger log = LoggerFactory.getLogger(UiActions.class);
    private final PermissionBackend permissionBackend;
    private final Provider<CurrentUser> userProvider;

    public static Predicate<UiAction.Description> enabled() {
        return UiAction.Description::isEnabled;
    }

    @Inject
    UiActions(PermissionBackend permissionBackend, Provider<CurrentUser> userProvider) {
        this.permissionBackend = permissionBackend;
        this.userProvider = userProvider;
    }

    public <R extends RestResource> Iterable<UiAction.Description> from(RestCollection<?, R> collection, R resource) {
        return this.from(collection.views(), resource);
    }

    public <R extends RestResource> Iterable<UiAction.Description> from(DynamicMap<RestView<R>> views, R resource) {
        List descs = Streams.stream(views).map(e -> this.describe((DynamicMap.Entry)e, resource)).filter(Objects::nonNull).collect(Collectors.toList());
        List<PermissionBackendCondition> conds = Streams.concat(descs.stream().flatMap(u -> Streams.stream(UiActions.visibleCondition(u))), descs.stream().flatMap(u -> Streams.stream(UiActions.enabledCondition(u)))).collect(Collectors.toList());
        this.permissionBackend.bulkEvaluateTest(conds);
        return descs.stream().filter(u -> u.isVisible()).collect(Collectors.toList());
    }

    private static Iterable<PermissionBackendCondition> visibleCondition(UiAction.Description u) {
        return u.getVisibleCondition().children(PermissionBackendCondition.class);
    }

    private static Iterable<PermissionBackendCondition> enabledCondition(UiAction.Description u) {
        return u.getEnabledCondition().children(PermissionBackendCondition.class);
    }

    @Nullable
    private <R extends RestResource> UiAction.Description describe(DynamicMap.Entry<RestView<R>> e, R resource) {
        Set<GlobalOrPluginPermission> globalRequired;
        RestView<R> view;
        int d = e.getExportName().indexOf(46);
        if (d < 0) {
            return null;
        }
        try {
            view = e.getProvider().get();
        }
        catch (RuntimeException err) {
            log.error("error creating view {}.{}", e.getPluginName(), e.getExportName(), err);
            return null;
        }
        if (!(view instanceof UiAction)) {
            return null;
        }
        UiAction.Description dsc = ((UiAction)view).getDescription(resource);
        if (dsc == null) {
            return null;
        }
        try {
            globalRequired = GlobalPermission.fromAnnotation(e.getPluginName(), view.getClass());
        }
        catch (PermissionBackendException err) {
            log.error("exception testing view {}.{}", e.getPluginName(), e.getExportName(), err);
            return null;
        }
        if (!globalRequired.isEmpty()) {
            PermissionBackend.WithUser withUser = this.permissionBackend.user(this.userProvider);
            Iterator<GlobalOrPluginPermission> i = globalRequired.iterator();
            BooleanCondition p = withUser.testCond(i.next());
            while (i.hasNext()) {
                p = BooleanCondition.or(p, withUser.testCond(i.next()));
            }
            dsc.setVisible(BooleanCondition.and(p, dsc.getVisibleCondition()));
        }
        String name = e.getExportName().substring(d + 1);
        PrivateInternals_UiActionDescription.setMethod(dsc, e.getExportName().substring(0, d));
        PrivateInternals_UiActionDescription.setId(dsc, "gerrit".equals(e.getPluginName()) ? name : e.getPluginName() + '~' + name);
        return dsc;
    }
}

