/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.MoreObjects;
import com.google.gerrit.server.git.LockFailureException;
import com.google.gerrit.server.git.MetaDataUpdate;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.ChangeIdUtil;
import org.eclipse.jgit.util.RawParseUtils;

public abstract class VersionedMetaData {
    protected RevCommit revision;
    protected RevWalk rw;
    protected ObjectReader reader;
    protected ObjectInserter inserter;
    protected DirCache newTree;

    protected abstract String getRefName();

    protected abstract void onLoad() throws IOException, ConfigInvalidException;

    protected abstract boolean onSave(CommitBuilder var1) throws IOException, ConfigInvalidException;

    public ObjectId getRevision() {
        return this.revision != null ? this.revision.copy() : null;
    }

    public void load(Repository db) throws IOException, ConfigInvalidException {
        Ref ref = db.getRefDatabase().exactRef(this.getRefName());
        this.load(db, ref != null ? ref.getObjectId() : null);
    }

    public void load(Repository db, ObjectId id) throws IOException, ConfigInvalidException {
        try (RevWalk walk = new RevWalk(db);){
            this.load(walk, id);
        }
    }

    public void load(RevWalk walk, ObjectId id) throws IOException, ConfigInvalidException {
        this.rw = walk;
        this.reader = walk.getObjectReader();
        try {
            this.revision = id != null ? walk.parseCommit(id) : null;
            this.onLoad();
        }
        finally {
            this.rw = null;
            this.reader = null;
        }
    }

    public void load(MetaDataUpdate update) throws IOException, ConfigInvalidException {
        this.load(update.getRepository());
    }

    public void load(MetaDataUpdate update, ObjectId id) throws IOException, ConfigInvalidException {
        this.load(update.getRepository(), id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RevCommit commit(MetaDataUpdate update) throws IOException {
        try (BatchMetaDataUpdate batch = this.openUpdate(update);){
            batch.write(update.getCommitBuilder());
            RevCommit revCommit = batch.commit();
            return revCommit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RevCommit commitToNewRef(MetaDataUpdate update, String refName) throws IOException {
        try (BatchMetaDataUpdate batch = this.openUpdate(update);){
            batch.write(update.getCommitBuilder());
            RevCommit revCommit = batch.createRef(refName);
            return revCommit;
        }
    }

    public BatchMetaDataUpdate openUpdate(final MetaDataUpdate update) throws IOException {
        final Repository db = update.getRepository();
        this.reader = db.newObjectReader();
        this.inserter = db.newObjectInserter();
        final RevWalk rw = new RevWalk(this.reader);
        final RevTree tree = this.revision != null ? rw.parseTree(this.revision) : null;
        this.newTree = this.readTree(tree);
        return new BatchMetaDataUpdate(){
            AnyObjectId src;
            AnyObjectId srcTree;
            {
                this.src = VersionedMetaData.this.revision;
                this.srcTree = tree;
            }

            @Override
            public void write(CommitBuilder commit) throws IOException {
                this.write(VersionedMetaData.this, commit);
            }

            private boolean doSave(VersionedMetaData config, CommitBuilder commit) throws IOException {
                DirCache nt = config.newTree;
                ObjectReader r = config.reader;
                ObjectInserter i = config.inserter;
                try {
                    config.newTree = VersionedMetaData.this.newTree;
                    config.reader = VersionedMetaData.this.reader;
                    config.inserter = VersionedMetaData.this.inserter;
                    boolean bl = config.onSave(commit);
                    return bl;
                }
                catch (ConfigInvalidException e) {
                    throw new IOException("Cannot update " + VersionedMetaData.this.getRefName() + " in " + db.getDirectory() + ": " + e.getMessage(), e);
                }
                finally {
                    config.newTree = nt;
                    config.reader = r;
                    config.inserter = i;
                }
            }

            @Override
            public void write(VersionedMetaData config, CommitBuilder commit) throws IOException {
                if (!this.doSave(config, commit)) {
                    return;
                }
                ObjectId res = VersionedMetaData.this.newTree.writeTree(VersionedMetaData.this.inserter);
                if (res.equals(this.srcTree) && !update.allowEmpty() && commit.getTreeId() == null) {
                    return;
                }
                if (commit.getTreeId() == null) {
                    commit.setTreeId(res);
                } else {
                    res = commit.getTreeId();
                }
                if (this.src != null) {
                    commit.addParentId(this.src);
                }
                if (update.insertChangeId()) {
                    ObjectId id = ChangeIdUtil.computeChangeId(res, VersionedMetaData.this.getRevision(), commit.getAuthor(), commit.getCommitter(), commit.getMessage());
                    commit.setMessage(ChangeIdUtil.insertId(commit.getMessage(), id));
                }
                this.src = VersionedMetaData.this.inserter.insert(commit);
                this.srcTree = res;
            }

            @Override
            public RevCommit createRef(String refName) throws IOException {
                if (Objects.equals(this.src, VersionedMetaData.this.revision)) {
                    return VersionedMetaData.this.revision;
                }
                return this.updateRef(ObjectId.zeroId(), this.src, refName);
            }

            @Override
            public RevCommit commit() throws IOException {
                return this.commitAt(VersionedMetaData.this.revision);
            }

            @Override
            public RevCommit commitAt(ObjectId expected) throws IOException {
                if (Objects.equals(this.src, expected)) {
                    return VersionedMetaData.this.revision;
                }
                return this.updateRef(MoreObjects.firstNonNull(expected, ObjectId.zeroId()), this.src, VersionedMetaData.this.getRefName());
            }

            @Override
            public void close() {
                VersionedMetaData.this.newTree = null;
                rw.close();
                if (VersionedMetaData.this.inserter != null) {
                    VersionedMetaData.this.inserter.close();
                    VersionedMetaData.this.inserter = null;
                }
                if (VersionedMetaData.this.reader != null) {
                    VersionedMetaData.this.reader.close();
                    VersionedMetaData.this.reader = null;
                }
            }

            private RevCommit updateRef(AnyObjectId oldId, AnyObjectId newId, String refName) throws IOException {
                BatchRefUpdate bru = update.getBatch();
                if (bru != null) {
                    bru.addCommand(new ReceiveCommand(oldId.toObjectId(), newId.toObjectId(), refName));
                    VersionedMetaData.this.inserter.flush();
                    VersionedMetaData.this.revision = rw.parseCommit(newId);
                    return VersionedMetaData.this.revision;
                }
                RefUpdate ru = db.updateRef(refName);
                ru.setExpectedOldObjectId(oldId);
                ru.setNewObjectId(newId);
                ru.setRefLogIdent(update.getCommitBuilder().getAuthor());
                String message = update.getCommitBuilder().getMessage();
                if (message == null) {
                    message = "meta data update";
                }
                try (BufferedReader reader = new BufferedReader(new StringReader(message));){
                    ru.setRefLogMessage("commit: " + reader.readLine(), true);
                }
                VersionedMetaData.this.inserter.flush();
                RefUpdate.Result result = ru.update();
                switch (result) {
                    case NEW: 
                    case FAST_FORWARD: {
                        VersionedMetaData.this.revision = rw.parseCommit(ru.getNewObjectId());
                        update.fireGitRefUpdatedEvent(ru);
                        return VersionedMetaData.this.revision;
                    }
                    case LOCK_FAILURE: {
                        throw new LockFailureException("Cannot update " + ru.getName() + " in " + db.getDirectory() + ": " + (Object)((Object)ru.getResult()), ru);
                    }
                }
                throw new IOException("Cannot update " + ru.getName() + " in " + db.getDirectory() + ": " + (Object)((Object)ru.getResult()));
            }
        };
    }

    protected DirCache readTree(RevTree tree) throws IOException, MissingObjectException, IncorrectObjectTypeException {
        DirCache dc = DirCache.newInCore();
        if (tree != null) {
            DirCacheBuilder b = dc.builder();
            b.addTree(new byte[0], 0, this.reader, tree);
            b.finish();
        }
        return dc;
    }

    protected Config readConfig(String fileName) throws IOException, ConfigInvalidException {
        Config rc = new Config();
        String text = this.readUTF8(fileName);
        if (!text.isEmpty()) {
            try {
                rc.fromText(text);
            }
            catch (ConfigInvalidException err) {
                StringBuilder msg = new StringBuilder("Invalid config file ").append(fileName).append(" in commit ").append(this.revision.name());
                if (err.getCause() != null) {
                    msg.append(": ").append(err.getCause());
                }
                throw new ConfigInvalidException(msg.toString(), err);
            }
        }
        return rc;
    }

    protected String readUTF8(String fileName) throws IOException {
        byte[] raw = this.readFile(fileName);
        return raw.length != 0 ? RawParseUtils.decode(raw) : "";
    }

    protected byte[] readFile(String fileName) throws IOException {
        if (this.revision == null) {
            return new byte[0];
        }
        try (TreeWalk tw = TreeWalk.forPath(this.reader, fileName, this.revision.getTree());){
            if (tw != null) {
                ObjectLoader obj = this.reader.open(tw.getObjectId(0), 3);
                byte[] byArray = obj.getCachedBytes(Integer.MAX_VALUE);
                return byArray;
            }
        }
        return new byte[0];
    }

    protected ObjectId getObjectId(String fileName) throws IOException {
        if (this.revision == null) {
            return null;
        }
        try (TreeWalk tw = TreeWalk.forPath(this.reader, fileName, this.revision.getTree());){
            if (tw != null) {
                ObjectId objectId = tw.getObjectId(0);
                return objectId;
            }
        }
        return null;
    }

    public List<PathInfo> getPathInfos(boolean recursive) throws IOException {
        try (TreeWalk tw = new TreeWalk(this.reader);){
            tw.addTree(this.revision.getTree());
            tw.setRecursive(recursive);
            ArrayList<PathInfo> paths = new ArrayList<PathInfo>();
            while (tw.next()) {
                paths.add(new PathInfo(tw));
            }
            ArrayList<PathInfo> arrayList = paths;
            return arrayList;
        }
    }

    protected static void set(Config rc, String section, String subsection, String name, String value) {
        if (value != null) {
            rc.setString(section, subsection, name, value);
        } else {
            rc.unset(section, subsection, name);
        }
    }

    protected static void set(Config rc, String section, String subsection, String name, boolean value) {
        if (value) {
            rc.setBoolean(section, subsection, name, value);
        } else {
            rc.unset(section, subsection, name);
        }
    }

    protected static <E extends Enum<?>> void set(Config rc, String section, String subsection, String name, E value, E defaultValue) {
        if (value != defaultValue) {
            rc.setEnum(section, subsection, name, value);
        } else {
            rc.unset(section, subsection, name);
        }
    }

    protected void saveConfig(String fileName, Config cfg) throws IOException {
        this.saveUTF8(fileName, cfg.toText());
    }

    protected void saveUTF8(String fileName, String text) throws IOException {
        this.saveFile(fileName, text != null ? Constants.encode(text) : null);
    }

    protected void saveFile(String fileName, byte[] raw) throws IOException {
        DirCacheEditor editor = this.newTree.editor();
        if (raw != null && 0 < raw.length) {
            final ObjectId blobId = this.inserter.insert(3, raw);
            editor.add(new DirCacheEditor.PathEdit(fileName){

                @Override
                public void apply(DirCacheEntry ent) {
                    ent.setFileMode(FileMode.REGULAR_FILE);
                    ent.setObjectId(blobId);
                }
            });
        } else {
            editor.add(new DirCacheEditor.DeletePath(fileName));
        }
        editor.finish();
    }

    public static interface BatchMetaDataUpdate {
        public void write(CommitBuilder var1) throws IOException;

        public void write(VersionedMetaData var1, CommitBuilder var2) throws IOException;

        public RevCommit createRef(String var1) throws IOException;

        public RevCommit commit() throws IOException;

        public RevCommit commitAt(ObjectId var1) throws IOException;

        public void close();
    }

    public static class PathInfo {
        public final FileMode fileMode;
        public final String path;
        public final ObjectId objectId;

        protected PathInfo(TreeWalk tw) {
            this.fileMode = tw.getFileMode(0);
            this.path = tw.getPathString();
            this.objectId = tw.getObjectId(0);
        }
    }
}

