/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.receive;

import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountLimits;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jgit.lib.Config;

@Singleton
class ReceiveConfig {
    final boolean checkMagicRefs;
    final boolean checkReferencedObjectsAreReachable;
    final boolean allowDrafts;
    final int maxBatchCommits;
    final boolean disablePrivateChanges;
    private final int systemMaxBatchChanges;
    private final AccountLimits.Factory limitsFactory;

    @Inject
    ReceiveConfig(@GerritServerConfig Config config, AccountLimits.Factory limitsFactory) {
        this.checkMagicRefs = config.getBoolean("receive", null, "checkMagicRefs", true);
        this.checkReferencedObjectsAreReachable = config.getBoolean("receive", null, "checkReferencedObjectsAreReachable", true);
        this.allowDrafts = config.getBoolean("change", null, "allowDrafts", false);
        this.maxBatchCommits = config.getInt("receive", null, "maxBatchCommits", 10000);
        this.systemMaxBatchChanges = config.getInt("receive", "maxBatchChanges", 0);
        this.disablePrivateChanges = config.getBoolean("change", null, "disablePrivateChanges", false);
        this.limitsFactory = limitsFactory;
    }

    public int getEffectiveMaxBatchChangesLimit(CurrentUser user) {
        AccountLimits limits = this.limitsFactory.create(user);
        if (limits.hasExplicitRange("batchChangesLimit")) {
            return limits.getRange("batchChangesLimit").getMax();
        }
        return this.systemMaxBatchChanges;
    }
}

