/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.validators;

import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.validators.OnSubmitValidationListener;
import com.google.gerrit.server.update.ChainedReceiveCommands;
import com.google.gerrit.server.validators.ValidationException;
import com.google.inject.Inject;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.revwalk.RevWalk;

public class OnSubmitValidators {
    private final DynamicSet<OnSubmitValidationListener> listeners;

    @Inject
    OnSubmitValidators(DynamicSet<OnSubmitValidationListener> listeners) {
        this.listeners = listeners;
    }

    public void validate(Project.NameKey project, ObjectReader objectReader, ChainedReceiveCommands commands) throws IntegrationException {
        try (RevWalk rw = new RevWalk(objectReader);){
            OnSubmitValidationListener.Arguments args = new OnSubmitValidationListener.Arguments(project, rw, commands);
            for (OnSubmitValidationListener listener : this.listeners) {
                listener.preBranchUpdate(args);
            }
        }
        catch (ValidationException e) {
            throw new IntegrationException(e.getMessage());
        }
    }

    public static interface Factory {
        public OnSubmitValidators create();
    }
}

