/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.account;

import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.gerrit.index.FieldDef;
import com.google.gerrit.index.SchemaUtil;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.index.RefState;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.ObjectId;

public class AccountField {
    public static final FieldDef<AccountState, Integer> ID = FieldDef.integer("id").stored().build(a -> a.getAccount().getId().get());
    public static final FieldDef<AccountState, Iterable<String>> EXTERNAL_ID = FieldDef.exact("external_id").buildRepeatable(a -> Iterables.transform(a.getExternalIds(), id -> id.key().get()));
    public static final FieldDef<AccountState, Iterable<String>> NAME_PART = FieldDef.prefix("name").buildRepeatable(a -> {
        String fullName = a.getAccount().getFullName();
        Set<String> parts = SchemaUtil.getNameParts(fullName, Iterables.transform(a.getExternalIds(), ExternalId::email));
        if (fullName != null) {
            parts.add(fullName.toLowerCase(Locale.US));
        }
        return parts;
    });
    public static final FieldDef<AccountState, String> FULL_NAME = FieldDef.exact("full_name").build(a -> a.getAccount().getFullName());
    public static final FieldDef<AccountState, String> ACTIVE = FieldDef.exact("inactive").build(a -> a.getAccount().isActive() ? "1" : "0");
    public static final FieldDef<AccountState, Iterable<String>> EMAIL = FieldDef.prefix("email").buildRepeatable(a -> FluentIterable.from(a.getExternalIds()).transform(ExternalId::email).append(Collections.singleton(a.getAccount().getPreferredEmail())).filter(Predicates.notNull()).transform(String::toLowerCase).toSet());
    public static final FieldDef<AccountState, String> PREFERRED_EMAIL = FieldDef.prefix("preferredemail").build(a -> {
        String preferredEmail = a.getAccount().getPreferredEmail();
        return preferredEmail != null ? preferredEmail.toLowerCase() : null;
    });
    public static final FieldDef<AccountState, String> PREFERRED_EMAIL_EXACT = FieldDef.exact("preferredemail_exact").build(a -> a.getAccount().getPreferredEmail());
    public static final FieldDef<AccountState, Timestamp> REGISTERED = FieldDef.timestamp("registered").build(a -> a.getAccount().getRegisteredOn());
    public static final FieldDef<AccountState, String> USERNAME = FieldDef.exact("username").build(a -> Strings.nullToEmpty(a.getUserName()).toLowerCase());
    public static final FieldDef<AccountState, Iterable<String>> WATCHED_PROJECT = FieldDef.exact("watchedproject").buildRepeatable(a -> FluentIterable.from(a.getProjectWatches().keySet()).transform(k -> k.project().get()).toSet());
    public static final FieldDef<AccountState, Iterable<byte[]>> REF_STATE = FieldDef.storedOnly("ref_state").buildRepeatable(a -> {
        if (a.getAccount().getMetaId() == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of(RefState.create(RefNames.refsUsers(a.getAccount().getId()), ObjectId.fromString(a.getAccount().getMetaId())).toByteArray(a.getAllUsersNameForIndexing()));
    });
    public static final FieldDef<AccountState, Iterable<byte[]>> EXTERNAL_ID_STATE = FieldDef.storedOnly("external_id_state").buildRepeatable(a -> a.getExternalIds().stream().filter(e -> e.blobId() != null).map(e -> e.toByteArray()).collect(Collectors.toSet()));

    private AccountField() {
    }
}

