/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.receive;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.server.mail.receive.MailComment;
import com.google.gerrit.server.mail.receive.MailMessage;
import com.google.gerrit.server.mail.receive.ParserUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class HtmlParser {
    private static final ImmutableList<String> MAIL_PROVIDER_EXTRAS = ImmutableList.of("gmail_extra", "gmail_quote");

    private HtmlParser() {
    }

    public static List<MailComment> parse(MailMessage email, Collection<Comment> comments, String changeUrl) {
        ArrayList<MailComment> parsedComments = new ArrayList<MailComment>();
        Document d = Jsoup.parse(email.htmlContent());
        PeekingIterator<Comment> iter = Iterators.peekingIterator(comments.iterator());
        String lastEncounteredFileName = null;
        Comment lastEncounteredComment = null;
        for (Element e : d.body().getAllElements()) {
            String content;
            String elementName = e.tagName();
            boolean isInBlockQuote = e.parents().stream().filter(p -> p.tagName().equals("blockquote")).findAny().isPresent();
            if (elementName.equals("a")) {
                String href = e.attr("href");
                if (!iter.hasNext()) continue;
                Comment perspectiveComment = iter.peek();
                if (href.equals(ParserUtil.filePath(changeUrl, perspectiveComment))) {
                    if (lastEncounteredFileName == null || !lastEncounteredFileName.equals(perspectiveComment.key.filename)) {
                        lastEncounteredFileName = perspectiveComment.key.filename;
                        lastEncounteredComment = null;
                        continue;
                    }
                    if (perspectiveComment.lineNbr != 0) continue;
                    lastEncounteredComment = perspectiveComment;
                    iter.next();
                    continue;
                }
                if (!ParserUtil.isCommentUrl(href, changeUrl, perspectiveComment)) continue;
                lastEncounteredComment = perspectiveComment;
                iter.next();
                continue;
            }
            if (isInBlockQuote || !elementName.equals("div") || MAIL_PROVIDER_EXTRAS.contains(e.className()) || Strings.isNullOrEmpty(content = e.ownText().replace('\u00a0', ' ').trim())) continue;
            if (lastEncounteredComment == null && lastEncounteredFileName == null) {
                if (Strings.isNullOrEmpty(content = ParserUtil.trimQuotation(content))) continue;
                ParserUtil.appendOrAddNewComment(new MailComment(content, null, null, MailComment.CommentType.CHANGE_MESSAGE), parsedComments);
                continue;
            }
            if (lastEncounteredComment == null) {
                ParserUtil.appendOrAddNewComment(new MailComment(content, lastEncounteredFileName, null, MailComment.CommentType.FILE_COMMENT), parsedComments);
                continue;
            }
            ParserUtil.appendOrAddNewComment(new MailComment(content, null, lastEncounteredComment, MailComment.CommentType.INLINE_COMMENT), parsedComments);
        }
        return parsedComments;
    }
}

