/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gerrit.server.mail.send.ReplyToChangeSender;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

public class DeleteVoteSender
extends ReplyToChangeSender {
    @Inject
    protected DeleteVoteSender(EmailArguments ea, @Assisted Project.NameKey project, @Assisted Change.Id id) throws OrmException {
        super(ea, "deleteVote", DeleteVoteSender.newChangeData(ea, project, id));
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        this.ccAllApprovals();
        this.bccStarredBy();
        this.includeWatchers(WatchConfig.NotifyType.ALL_COMMENTS);
        this.removeUsersThatIgnoredTheChange();
    }

    @Override
    protected void formatChange() throws EmailException {
        this.appendText(this.textTemplate("DeleteVote"));
        if (this.useHtml()) {
            this.appendHtml(this.soyHtmlTemplate("DeleteVoteHtml"));
        }
    }

    @Override
    protected boolean supportsHtml() {
        return true;
    }

    public static interface Factory
    extends ReplyToChangeSender.Factory<DeleteVoteSender> {
        @Override
        public DeleteVoteSender create(Project.NameKey var1, Change.Id var2);
    }
}

