/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.server.ReviewerByEmailSet;
import com.google.gerrit.server.ReviewerSet;
import com.google.gerrit.server.ReviewerStatusUpdate;
import com.google.gerrit.server.notedb.AutoValue_ChangeNotesState;
import com.google.gerrit.server.notedb.AutoValue_ChangeNotesState_ChangeColumns;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;

@AutoValue
public abstract class ChangeNotesState {
    static ChangeNotesState empty(Change change) {
        return new AutoValue_ChangeNotesState(null, change.getId(), null, ImmutableSet.of(), ImmutableSet.of(), ImmutableList.of(), ImmutableList.of(), ReviewerSet.empty(), ReviewerByEmailSet.empty(), ReviewerSet.empty(), ReviewerByEmailSet.empty(), ImmutableList.of(), ImmutableList.of(), ImmutableList.of(), ImmutableList.of(), ImmutableListMultimap.of(), ImmutableListMultimap.of(), null, null, null, true, null);
    }

    static ChangeNotesState create(@Nullable ObjectId metaId, Change.Id changeId, Change.Key changeKey, Timestamp createdOn, Timestamp lastUpdatedOn, Account.Id owner, String branch, @Nullable PatchSet.Id currentPatchSetId, String subject, @Nullable String topic, @Nullable String originalSubject, @Nullable String submissionId, @Nullable Account.Id assignee, @Nullable Change.Status status, @Nullable Set<Account.Id> pastAssignees, @Nullable Set<String> hashtags, Map<PatchSet.Id, PatchSet> patchSets, ListMultimap<PatchSet.Id, PatchSetApproval> approvals, ReviewerSet reviewers, ReviewerByEmailSet reviewersByEmail, ReviewerSet pendingReviewers, ReviewerByEmailSet pendingReviewersByEmail, List<Account.Id> allPastReviewers, List<ReviewerStatusUpdate> reviewerUpdates, List<SubmitRecord> submitRecords, List<ChangeMessage> allChangeMessages, ListMultimap<PatchSet.Id, ChangeMessage> changeMessagesByPatchSet, ListMultimap<RevId, Comment> publishedComments, @Nullable Timestamp readOnlyUntil, @Nullable Boolean isPrivate, @Nullable Boolean workInProgress, boolean hasReviewStarted, @Nullable Change.Id revertOf) {
        if (hashtags == null) {
            hashtags = ImmutableSet.of();
        }
        return new AutoValue_ChangeNotesState(metaId, changeId, new AutoValue_ChangeNotesState_ChangeColumns(changeKey, createdOn, lastUpdatedOn, owner, branch, currentPatchSetId, subject, topic, originalSubject, submissionId, assignee, status, isPrivate, workInProgress, hasReviewStarted, revertOf), ImmutableSet.copyOf(pastAssignees), ImmutableSet.copyOf(hashtags), ImmutableList.copyOf(patchSets.entrySet()), ImmutableList.copyOf(approvals.entries()), reviewers, reviewersByEmail, pendingReviewers, pendingReviewersByEmail, ImmutableList.copyOf(allPastReviewers), ImmutableList.copyOf(reviewerUpdates), ImmutableList.copyOf(submitRecords), ImmutableList.copyOf(allChangeMessages), ImmutableListMultimap.copyOf(changeMessagesByPatchSet), ImmutableListMultimap.copyOf(publishedComments), readOnlyUntil, isPrivate, workInProgress, hasReviewStarted, revertOf);
    }

    @Nullable
    abstract ObjectId metaId();

    abstract Change.Id changeId();

    @Nullable
    abstract ChangeColumns columns();

    abstract ImmutableSet<Account.Id> pastAssignees();

    abstract ImmutableSet<String> hashtags();

    abstract ImmutableList<Map.Entry<PatchSet.Id, PatchSet>> patchSets();

    abstract ImmutableList<Map.Entry<PatchSet.Id, PatchSetApproval>> approvals();

    abstract ReviewerSet reviewers();

    abstract ReviewerByEmailSet reviewersByEmail();

    abstract ReviewerSet pendingReviewers();

    abstract ReviewerByEmailSet pendingReviewersByEmail();

    abstract ImmutableList<Account.Id> allPastReviewers();

    abstract ImmutableList<ReviewerStatusUpdate> reviewerUpdates();

    abstract ImmutableList<SubmitRecord> submitRecords();

    abstract ImmutableList<ChangeMessage> allChangeMessages();

    abstract ImmutableListMultimap<PatchSet.Id, ChangeMessage> changeMessagesByPatchSet();

    abstract ImmutableListMultimap<RevId, Comment> publishedComments();

    @Nullable
    abstract Timestamp readOnlyUntil();

    @Nullable
    abstract Boolean isPrivate();

    @Nullable
    abstract Boolean isWorkInProgress();

    @Nullable
    abstract Boolean hasReviewStarted();

    @Nullable
    abstract Change.Id revertOf();

    Change newChange(Project.NameKey project) {
        ChangeColumns c = Preconditions.checkNotNull(this.columns(), "columns are required");
        Change change = new Change(c.changeKey(), this.changeId(), c.owner(), new Branch.NameKey(project, c.branch()), c.createdOn());
        this.copyNonConstructorColumnsTo(change);
        change.setNoteDbState("N");
        return change;
    }

    void copyColumnsTo(Change change) throws IOException {
        ChangeColumns c = this.columns();
        Preconditions.checkState(c != null && this.metaId() != null, "missing columns or metaId in ChangeNotesState; is NoteDb enabled? %s", (Object)this);
        this.checkMetaId(change);
        change.setKey(c.changeKey());
        change.setOwner(c.owner());
        change.setDest(new Branch.NameKey(change.getProject(), c.branch()));
        change.setCreatedOn(c.createdOn());
        this.copyNonConstructorColumnsTo(change);
    }

    private void checkMetaId(Change change) throws IOException {
        NoteDbChangeState state = NoteDbChangeState.parse(change);
        if (state == null) {
            return;
        }
        if (state.getPrimaryStorage() == NoteDbChangeState.PrimaryStorage.NOTE_DB) {
            return;
        }
        Preconditions.checkState(state.getRefState().isPresent(), "expected RefState: %s", (Object)state);
        ObjectId idFromState = state.getRefState().get().changeMetaId();
        if (!idFromState.equals(this.metaId())) {
            throw new IOException("cannot copy ChangeNotesState into Change " + this.changeId() + "; this ChangeNotesState was created from " + this.metaId() + ", but change requires state " + idFromState);
        }
    }

    private void copyNonConstructorColumnsTo(Change change) {
        ChangeColumns c = Preconditions.checkNotNull(this.columns(), "columns are required");
        if (c.status() != null) {
            change.setStatus(c.status());
        }
        change.setTopic(Strings.emptyToNull(c.topic()));
        change.setLastUpdatedOn(c.lastUpdatedOn());
        change.setSubmissionId(c.submissionId());
        change.setAssignee(c.assignee());
        change.setPrivate(c.isPrivate() == null ? false : c.isPrivate());
        change.setWorkInProgress(c.isWorkInProgress() == null ? false : c.isWorkInProgress());
        change.setReviewStarted(c.hasReviewStarted() == null ? false : c.hasReviewStarted());
        change.setRevertOf(c.revertOf());
        if (!this.patchSets().isEmpty()) {
            change.setCurrentPatchSet(c.currentPatchSetId(), c.subject(), c.originalSubject());
        } else {
            change.clearCurrentPatchSet();
        }
    }

    @AutoValue
    static abstract class ChangeColumns {
        ChangeColumns() {
        }

        abstract Change.Key changeKey();

        abstract Timestamp createdOn();

        abstract Timestamp lastUpdatedOn();

        abstract Account.Id owner();

        abstract String branch();

        @Nullable
        abstract PatchSet.Id currentPatchSetId();

        abstract String subject();

        @Nullable
        abstract String topic();

        @Nullable
        abstract String originalSubject();

        @Nullable
        abstract String submissionId();

        @Nullable
        abstract Account.Id assignee();

        @Nullable
        abstract Change.Status status();

        @Nullable
        abstract Boolean isPrivate();

        @Nullable
        abstract Boolean isWorkInProgress();

        @Nullable
        abstract Boolean hasReviewStarted();

        @Nullable
        abstract Change.Id revertOf();
    }
}

