/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.permissions;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.ChangePermissionOrLabel;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.Set;

public class FailedPermissionBackend {
    public static PermissionBackend.ForProject project(String message) {
        return FailedPermissionBackend.project(message, null);
    }

    public static PermissionBackend.ForProject project(String message, Throwable cause) {
        return new FailedProject(message, cause);
    }

    public static PermissionBackend.ForRef ref(String message) {
        return FailedPermissionBackend.ref(message, null);
    }

    public static PermissionBackend.ForRef ref(String message, Throwable cause) {
        return new FailedRef(message, cause);
    }

    public static PermissionBackend.ForChange change(String message) {
        return FailedPermissionBackend.change(message, null);
    }

    public static PermissionBackend.ForChange change(String message, Throwable cause) {
        return new FailedChange(message, cause);
    }

    private FailedPermissionBackend() {
    }

    private static class FailedChange
    extends PermissionBackend.ForChange {
        private final String message;
        private final Throwable cause;

        FailedChange(String message, Throwable cause) {
            this.message = message;
            this.cause = cause;
        }

        @Override
        public PermissionBackend.ForChange database(Provider<ReviewDb> db) {
            return this;
        }

        @Override
        public PermissionBackend.ForChange user(CurrentUser user) {
            return this;
        }

        @Override
        public void check(ChangePermissionOrLabel perm) throws PermissionBackendException {
            throw new PermissionBackendException(this.message, this.cause);
        }

        @Override
        public <T extends ChangePermissionOrLabel> Set<T> test(Collection<T> permSet) throws PermissionBackendException {
            throw new PermissionBackendException(this.message, this.cause);
        }

        @Override
        public CurrentUser user() {
            throw new UnsupportedOperationException("FailedPermissionBackend is not scoped to user");
        }
    }

    private static class FailedRef
    extends PermissionBackend.ForRef {
        private final String message;
        private final Throwable cause;

        FailedRef(String message, Throwable cause) {
            this.message = message;
            this.cause = cause;
        }

        @Override
        public PermissionBackend.ForRef database(Provider<ReviewDb> db) {
            return this;
        }

        @Override
        public PermissionBackend.ForRef user(CurrentUser user) {
            return this;
        }

        @Override
        public PermissionBackend.ForChange change(ChangeData cd) {
            return new FailedChange(this.message, this.cause);
        }

        @Override
        public PermissionBackend.ForChange change(ChangeNotes notes) {
            return new FailedChange(this.message, this.cause);
        }

        @Override
        public PermissionBackend.ForChange indexedChange(ChangeData cd, ChangeNotes notes) {
            return new FailedChange(this.message, this.cause);
        }

        @Override
        public void check(RefPermission perm) throws PermissionBackendException {
            throw new PermissionBackendException(this.message, this.cause);
        }

        @Override
        public Set<RefPermission> test(Collection<RefPermission> permSet) throws PermissionBackendException {
            throw new PermissionBackendException(this.message, this.cause);
        }
    }

    private static class FailedProject
    extends PermissionBackend.ForProject {
        private final String message;
        private final Throwable cause;

        FailedProject(String message, Throwable cause) {
            this.message = message;
            this.cause = cause;
        }

        @Override
        public PermissionBackend.ForProject database(Provider<ReviewDb> db) {
            return this;
        }

        @Override
        public PermissionBackend.ForProject user(CurrentUser user) {
            return this;
        }

        @Override
        public PermissionBackend.ForRef ref(String ref) {
            return new FailedRef(this.message, this.cause);
        }

        @Override
        public void check(ProjectPermission perm) throws PermissionBackendException {
            throw new PermissionBackendException(this.message, this.cause);
        }

        @Override
        public Set<ProjectPermission> test(Collection<ProjectPermission> permSet) throws PermissionBackendException {
            throw new PermissionBackendException(this.message, this.cause);
        }
    }
}

