/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.GerritPersonIdentProvider;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePath;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.config.TrackingFooters;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.securestore.SecureStore;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.nio.file.Path;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.PersonIdent;

@Singleton
class CopyConfigModule
extends AbstractModule {
    @Inject
    @SitePath
    private Path sitePath;
    @Inject
    private SitePaths sitePaths;
    @Inject
    private TrackingFooters trackingFooters;
    @Inject
    @GerritServerConfig
    private Config gerritServerConfig;
    @Inject
    private SchemaFactory<ReviewDb> schemaFactory;
    @Inject
    private GitRepositoryManager gitRepositoryManager;
    @Inject
    @AnonymousCowardName
    private String anonymousCowardName;
    @Inject
    private GerritPersonIdentProvider serverIdentProvider;
    @Inject
    private SecureStore secureStore;

    @Provides
    @SitePath
    Path getSitePath() {
        return this.sitePath;
    }

    @Provides
    SitePaths getSitePaths() {
        return this.sitePaths;
    }

    @Provides
    TrackingFooters getTrackingFooters() {
        return this.trackingFooters;
    }

    @Provides
    @GerritServerConfig
    Config getGerritServerConfig() {
        return this.gerritServerConfig;
    }

    @Provides
    SchemaFactory<ReviewDb> getSchemaFactory() {
        return this.schemaFactory;
    }

    @Provides
    GitRepositoryManager getGitRepositoryManager() {
        return this.gitRepositoryManager;
    }

    @Provides
    @AnonymousCowardName
    String getAnonymousCowardName() {
        return this.anonymousCowardName;
    }

    @Provides
    @GerritPersonIdent
    PersonIdent getServerIdent() {
        return this.serverIdentProvider.get();
    }

    @Provides
    SecureStore getSecureStore() {
        return this.secureStore;
    }

    @Inject
    CopyConfigModule() {
    }

    @Override
    protected void configure() {
    }
}

