/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.common.InstallPluginInput;
import com.google.gerrit.extensions.common.PluginInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.plugins.ListPlugins;
import com.google.gerrit.server.plugins.PluginInstallException;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.gerrit.server.plugins.PluginResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.zip.ZipException;

@RequiresCapability(value="administrateServer")
public class InstallPlugin
implements RestModifyView<TopLevelResource, InstallPluginInput> {
    private final PluginLoader loader;
    private String name;
    private boolean created;

    @Inject
    InstallPlugin(PluginLoader loader) {
        this.loader = loader;
    }

    public InstallPlugin setName(String name) {
        this.name = name;
        return this;
    }

    public InstallPlugin setCreated(boolean created) {
        this.created = created;
        return this;
    }

    public Response<PluginInfo> apply(TopLevelResource resource, InstallPluginInput input) throws BadRequestException, MethodNotAllowedException, IOException {
        Response<PluginInfo> response;
        block11: {
            if (!this.loader.isRemoteAdminEnabled()) {
                throw new MethodNotAllowedException("remote installation is disabled");
            }
            InputStream in = this.openStream(input);
            try {
                String pluginName = this.loader.installPluginFromStream(this.name, in);
                PluginInfo info = ListPlugins.toPluginInfo(this.loader.get(pluginName));
                Response<PluginInfo> response2 = response = this.created ? Response.created(info) : Response.ok(info);
                if (in == null) break block11;
            }
            catch (Throwable pluginName) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable info) {
                            pluginName.addSuppressed(info);
                        }
                    }
                    throw pluginName;
                }
                catch (PluginInstallException e) {
                    StringWriter buf = new StringWriter();
                    buf.write(String.format("cannot install %s", this.name));
                    if (e.getCause() instanceof ZipException) {
                        buf.write(": ");
                        buf.write(e.getCause().getMessage());
                    } else {
                        buf.write(":\n");
                        PrintWriter pw = new PrintWriter(buf);
                        e.printStackTrace(pw);
                        pw.flush();
                    }
                    throw new BadRequestException(buf.toString());
                }
            }
            in.close();
        }
        return response;
    }

    private InputStream openStream(InstallPluginInput input) throws IOException, BadRequestException {
        if (input.raw != null) {
            return input.raw.getInputStream();
        }
        try {
            return new URL(input.url).openStream();
        }
        catch (IOException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    @RequiresCapability(value="administrateServer")
    static class Overwrite
    implements RestModifyView<PluginResource, InstallPluginInput> {
        private final Provider<InstallPlugin> install;

        @Inject
        Overwrite(Provider<InstallPlugin> install) {
            this.install = install;
        }

        public Response<PluginInfo> apply(PluginResource resource, InstallPluginInput input) throws BadRequestException, MethodNotAllowedException, IOException {
            return this.install.get().setName(resource.getName()).apply(TopLevelResource.INSTANCE, input);
        }
    }
}

